<?php


Contao\System::loadLanguageFile('tl_content');

$GLOBALS['TL_DCA']['tl_dz_socialmedia_twitter'] = array
(

    // Config
    'config' => array
    (
        'dataContainer' => 'Table',
        'enableVersioning' => true,
//        'onload_callback' => array
//        (
//            array('tl_dz_socialmedia_twitter', 'checkPermission')
//        ),
        'sql' => array
        (
            'keys' => array
            (
                'id' => 'primary',
            )
        )
    ),

    // List
    'list' => array
    (
        'sorting' => array
        (
            'mode' => 2,
            'fields' => array('accountName'),
            'panelLayout' => 'sort,search;filter;limit',
            //'headerFields'            => array('name_de', 'name_en'),
//            'paste_button_callback' => array('tl_dz_socialmedia_twitter', 'pasteElement'),
            'disableGrouping' => true,
        ),
        'label' => array
        (
            'fields' => array('accountName'),
            'format' => '%s',
            'showColumns' => true,
//            'label_callback' => array('tl_dz_socialmedia_twitter', 'generateLabel'),
        ),
        'global_operations' => array
        (
//            'all' => array
//            (
//                'label' => &$GLOBALS['TL_LANG']['MSC']['all'],
//                'href' => 'act=select',
//                'class' => 'header_edit_all',
//                'attributes' => 'onclick="Backend.getScrollOffset()" accesskey="e"'
//            )
        ),
        'operations' => array
        (
            'edit' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_content']['edit'],
                'href' => 'act=edit',
                'icon' => 'edit.svg'
            ),
//            'copy' => array
//          public function toggleIcon($row, $href, $label, $title, $icon, $attributes)
//    {
//        if (strlen(Input::get('tid'))) {
//            $this->setVisibility(Input::get('tid'), (Input::get('state') == 1));
//            $this->redirect($this->getReferer());
//        }
//
//        $href .= '&tid=' . $row['id'] . '&state=' . ($row['published'] ? 0 : 1);
//
//        if (!$row['published']) {
//            $icon = 'invisible.gif';
//        }
//
//        return '<a href="' . $this->addToUrl($href) . '" title="' . specialchars($title) . '" ' . $attributes . '>' . Image::getHtml($icon, $label, 'data-state="' . ($row['published'] ? 1 : 0) . '"') . '</a> ';
//    }
//
//    public function setVisibility($id, $isVisible)
//    {
//        $post = \Dmkzwo\ContaoSocialmediaBundle\Model\InstagramPostModel::findByPk($id);
//        $post->published = $isVisible ? 1 : 0;
//        $post->save();
//    }      (
//                'label' => &$GLOBALS['TL_LANG']['tl_dz_socialmedia_twitter']['copy'],
//                'href' => 'act=paste&amp;mode=copy',
//                'icon' => 'copy.svg'
//            ),
//            'cut' => array
//            (
//                'label' => &$GLOBALS['TL_LANG']['tl_dz_socialmedia_twitter']['cut'],
//                'href' => 'act=paste&amp;mode=cut',
//                'icon' => 'cut.svg'
//            ),
            'delete' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_content']['delete'],
                'href' => 'act=delete',
                'icon' => 'delete.svg',
                'attributes' => 'onclick="if(!confirm(\'' . $GLOBALS['TL_LANG']['MSC']['deleteConfirm'] . '\'))return false;Backend.getScrollOffset()"'
            ),
            'toggle' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_dz_socialmedia_twitter']['toggle'],
                'icon' => 'visible.svg',
                'attributes' => 'onclick="Backend.getScrollOffset();return AjaxRequest.toggleVisibility(this,%s)"',
                'button_callback' => array('tl_dz_socialmedia_twitter', 'toggleIcon')
            ),
            'show' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_content']['show'],
                'href' => 'act=show',
                'icon' => 'show.svg'
            )
        )
    ),

    // Palettes
    'palettes' => array
    (
//        'default'                     => 'name_de,name_en;{publish_legend},published'
//        '__selector__' => ['addcoverimage'],
//        'default' => 'title,alias,identifier,releasedate,docfile,language,targetsd,targetev,published,description,longdescription,addcoverimage;{meta_legend},types,doctypes,allcategories,categories'
        'default' => 'accountName,twitterConsumerKey,twitterConsumerSecret,twitterAccessToken,twitterAccessTokenSecret,queryParam,publishMode,published,imageSrc,notifyOnError,notificationDisabled'
    ),

//    'subpalettes' => array
//    (
//        'addcoverimage' => 'coverimage',
//    ),


// Fields
    'fields' => array
    (
        'id' => array
        (
            'sql' => "int(10) unsigned NOT NULL auto_increment"
        ),
        'tstamp' => array
        (
            'sql' => "int(10) unsigned NOT NULL default 0"
        ),
        'published' => array
        (
            'exclude' => true,
            'filter' => true,
            'flag' => 2,
            'inputType' => 'checkbox',
            'eval' => array('doNotCopy' => true, 'tl_class' => 'w50'),
            'sql' => "char(1) NOT NULL default '1'"
        ),
        'accountName' => array
        (
            'exclude' => false,
            'sorting' => true,
            'inputType' => 'text',
            'eval' => array('mandatory' => true, 'maxlength' => 255, 'tl_class' => 'w50'),
            'sql' => "varchar(255) NOT NULL default ''"
        ),
        'twitterConsumerKey' => array
        (
            'exclude' => false,
            'sorting' => true,
            'inputType' => 'text',
            'eval' => array('mandatory' => true, 'maxlength' => 255, 'tl_class' => 'clr w50'),
            'sql' => "varchar(255) NOT NULL default ''"
        ),
        'twitterConsumerSecret' => array
        (
            'exclude' => false,
            'sorting' => true,
            'inputType' => 'text',
            'eval' => array('mandatory' => true, 'maxlength' => 255, 'tl_class' => 'w50'),
            'sql' => "varchar(255) NOT NULL default ''"
        ),
        'twitterAccessToken' => array
        (
            'exclude' => false,
            'sorting' => false,
            'inputType' => 'textarea',
            'eval' => array('mandatory' => true, 'tl_class' => 'clr long'),
            'sql' => "text NULL"
        ),
        'twitterAccessTokenSecret' => array
        (
            'exclude' => false,
            'sorting' => false,
            'inputType' => 'textarea',
            'eval' => array('mandatory' => true, 'tl_class' => 'clr long'),
            'sql' => "text NULL"
        ),
        'queryParam' => array
        (
            'exclude' => false,
            'sorting' => true,
            'inputType' => 'text',
            'eval' => array('mandatory' => true, 'maxlength' => 255, 'tl_class' => 'w50'),
            'sql' => "varchar(255) NOT NULL default ''"
        ),
        'publishMode' => array
        (
            'exclude' => false,
            'inputType' => 'radio',
            'options' => ['whitelist', 'blacklist'],
            'eval' => array('mandatory' => true, 'tl_class' => 'clr w50'),
            'sql' => "varchar(16) NOT NULL default 'blacklist'"
        ),
        'imageSrc' => array
        (
            'exclude' => false,
            'inputType' => 'fileTree',
            'eval' => array('mandatory' => true, 'filesOnly' => true, 'fieldType' => 'radio', 'tl_class' => 'clr w50'),
            'sql' => "binary(16) NULL"
        ),
        'notifyOnError' => array
        (
            'exclude' => false,
            'inputType' => 'text',
            'eval' => array('mandatory' => false, 'maxlength' => 255, 'tl_class' => 'clr w50'),
            'sql' => "varchar(255) NOT NULL default ''"
        ),
        'notificationDisabled' => array
        (
            'exclude' => true,
            'inputType' => 'checkbox',
            'eval' => array('doNotCopy' => true, 'tl_class' => 'm12 w50'),
            'sql' => "char(1) NOT NULL default ''"
        ),
//        'detailPage' => array
//        (
//            'label' => &$GLOBALS['TL_LANG']['tl_dz_socialmedia_twitter']['detailPage'],
//            'exclude' => true,
//            'inputType' => 'pageTree',
//            'eval' => array('mandatory' => true, 'fieldType' => 'radio', 'tl_class' => 'w50'),
//            'sql' => "int(10) unsigned NOT NULL default '0'"
//        ),
//        'title' => array
//        (
//            'label' => &$GLOBALS['TL_LANG']['tl_dz_socialmedia_twitter']['title'],
//            'exclude' => false,
//            'sorting' => true,
//            'flag' => 11,
//            'inputType' => 'text',
//            'eval' => array('mandatory' => true, 'maxlength' => 255, 'tl_class' => 'clr long'),
//            'sql' => "text NULL"
//        ),
//        'shortTitle' => array
//        (
//            'label' => &$GLOBALS['TL_LANG']['tl_dz_socialmedia_twitter']['title'],
//            'exclude' => false,
//            'sorting' => true,
//            'flag' => 11,
//            'inputType' => 'text',
//            'eval' => array('mandatory' => true, 'maxlength' => 255, 'tl_class' => 'w50'),
//            'sql' => "text NULL"
//        ),
//        'description' => array
//        (
//            'label' => &$GLOBALS['TL_LANG']['tl_dz_socialmedia_twitter']['description'],
//            'exclude' => true,
//            'inputType' => 'textarea',
//            'eval' => array('rte' => 'tinyMCE', 'helpwizard' => true, 'tl_class' => 'clr'),
//            'sql' => "text NULL"
//        ),

    )
);


/**
 * Provide miscellaneous methods that are used by the data configuration array.
 *
 * @author Leo Feyer <https://github.com/leofeyer>
 */
class tl_dz_socialmedia_twitter extends Contao\Backend
{

    /**
     * Import the back end user object
     */
    public function __construct()
    {
        parent::__construct();
        $this->import('Contao\BackendUser', 'User');
    }

    /**
     * Check permissions to edit table tl_dz_socialmedia_twitter
     */
    public function checkPermission()
    {
        $bundles = Contao\System::getContainer()->getParameter('kernel.bundles');

    }

    public function toggleIcon($row, $href, $label, $title, $icon, $attributes)
    {
        if (strlen(Input::get('tid'))) {
            $this->setVisibility(Input::get('tid'), (Input::get('state') == 1));
            $this->redirect($this->getReferer());
        }

        $href .= '&tid=' . $row['id'] . '&state=' . ($row['published'] ? 0 : 1);

        if (!$row['published']) {
            $icon = 'invisible.gif';
        }

        return '<a href="' . $this->addToUrl($href) . '" title="' . specialchars($title) . '" ' . $attributes . '>' . Image::getHtml($icon, $label, 'data-state="' . ($row['published'] ? 1 : 0) . '"') . '</a> ';
    }

    public function setVisibility($id, $isVisible)
    {
        $post = \Dmkzwo\ContaoSocialmediaBundle\Model\InstagramAccountModel::findByPk($id);
        $post->published = $isVisible ? 1 : 0;
        $post->save();
    }

//    public function pasteElement(DataContainer $dc, $row, $table, $cr, $arrClipboard)
//    {
//        $imagePasteAfter = Image::getHtml('pasteafter.gif',
//            sprintf($GLOBALS['TL_LANG'][$table]['pasteafter'][1], $row['id']));
//        return '<a href="' . $this->addToUrl('act=' . $arrClipboard['mode'] . '&mode=1&pid=' . $row['id']) . '" title="' . specialchars(sprintf($GLOBALS['TL_LANG'][$table]['pasteafter'][1],
//                $row['id'])) . '" onclick="Backend.getScrollOffset()">' . $imagePasteAfter . '</a> ';
//    }

}
