<?php

namespace Dmkzwo\ContaoSocialmediaBundle\Model;

class TwitterAccountModel extends AccountModel
{
    protected static $strTable = 'tl_dz_socialmedia_twitter';

    public static function findPublishedAccountIds() {
        return self::findByPublished('1')->fetchEach('id');
    }

    public static function getPublishedAccountOptions() {
        $publishedAccounts = self::findByPublished('1');

        $options = [];

        foreach ($publishedAccounts as $publishedAccount) {
            $options[$publishedAccount->id] = $publishedAccount->accountName;
        }

        return $options;
    }
}

class_alias(TwitterAccountModel::class, 'TwitterAccountModel');
// and if tablename differs from model name:
class_alias(TwitterAccountModel::class, 'DzSocialmediaTwitterModel');
