<?php

namespace Dmkzwo\ContaoSocialmediaBundle\Model;

class InstagramPostModel extends \Model
{
    protected static $strTable = 'tl_dz_socialmedia_instagram_post';

    public static function findPostsFromAccounts($accountIds, $limit = 10) {
        $instagramAccountUserIdsStr = implode(',', $accountIds);

        $posts = InstagramPostModel::findBy(
            ['pid IN ('.$instagramAccountUserIdsStr.')', 'hideOnWall<>?'],
            ['1'],
            [
                'limit' => $limit,
                'order' => 'tstamp DESC',
                'return' => 'Array',
            ]
        );

        return $posts;
    }

}

class_alias(InstagramPostModel::class, 'InstagramPostModel');
// and if tablename differs from model name:
class_alias(InstagramPostModel::class, 'DzSocialmediaInstagramPostModel');
