<?php

namespace Dmkzwo\ContaoSocialmediaBundle\Model;

class FacebookAccountModel extends AccountModel
{
    protected static $strTable = 'tl_dz_socialmedia_facebook';

    public static function findPublishedAccountIds() {
        return self::findByPublished('1')->fetchEach('appId');
    }

    public static function getPublishedAccountOptions() {
        $publishedAccounts = self::findByPublished('1');

        $options = [];

        foreach ($publishedAccounts as $publishedAccount) {
            $options[$publishedAccount->id] = $publishedAccount->accountName;
        }

        return $options;
    }
}

class_alias(FacebookAccountModel::class, 'FacebookAccountModel');
// and if tablename differs from model name:
class_alias(FacebookAccountModel::class, 'DzSocialmediaFacebookModel');
