<?php

namespace Dmkzwo\ContaoSocialmediaBundle\Library;

use Dmkzwo\ContaoSocialmediaBundle\Classes\FacebookApi;
use Dmkzwo\ContaoSocialmediaBundle\Model\FacebookAccountModel;
use Dmkzwo\ContaoSocialmediaBundle\Model\FacebookPostModel;


class FacebookUpdater
{
    protected $api;
    protected $account;
    protected $accountId;

    protected $userId;
    protected $accountName;
    protected $imageDir;

    protected $config;

    public function __construct($account, $api, $config)
    {
        $this->account = $account;
        $this->accountId = $account->id;
        $this->api = $api;
        $this->config = $config;

    }


    public function run() {
        $this->logRun();

        $this->prepareDirectories();
        $this->updatePosts();
    }

    protected function prepareDirectories() {
        $this->imageDir = \System::getContainer()->getParameter('facebook.social_media_dir');

        $directories = [
            $this->imageDir,
        ];

        foreach ($directories as $directory) {
            $dir = \System::getContainer()->getParameter('kernel.project_dir') . DIRECTORY_SEPARATOR . $directory;
            if (!file_exists($dir)) {
                mkdir($dir, 0777, true);
            }
        }
    }

    protected function updatePosts() {
        $posts = $this->api->getFeeds();

        if (!isset($posts)) {
            return;
        }

        if (is_array($posts) && sizeof($posts)) {
            foreach ($posts as $post) {
                self::createOrUpdatePost($post);
            }
        }
//        var_dump($posts);
    }

    protected function createOrUpdatePost($post) {
//        echo '<pre>';
//        var_dump($post);
//        echo '</pre>';
//        echo '<br><br>';
//        return;

        $postId = $post['id'];

        $postObj = FacebookPostModel::findOneBy('postId', $postId);

        $action = '';

        if ($postObj) {
            // update
            $action = 'UPDATE';

            $postObj->message = FacebookApi::getMessage($post);
            $postObj->mediaUrl = FacebookApi::getPicture($post);
            $postObj->totalLikes = FacebookApi::getTotalLikes($post);

            $postObj->save();

        } else {
            // create
            $action = 'CREATE';

//            $facebookAccount = FacebookAccountModel::findByPk($this->accountId);

            $postObj = new FacebookPostModel();

            $postObj->pid = $this->accountId;
            $postObj->published = ($this->account->publishMode == 'blacklist') ? '1' : '';
            $postObj->hideOnWall = ($this->account->publishMode == 'blacklist') ? '' : '1';
            $postObj->postId = $postId;
            $postObj->accountId = $this->accountId;
//            $newPostObj->userId = $this->userId;
            $postObj->tstamp = FacebookApi::getCreatedTime($post);
            $postObj->message = FacebookApi::getMessage($post);
            $postObj->mediaUrl = FacebookApi::getPicture($post);
            $postObj->permaLink = FacebookApi::getPermaLink($post);
            $postObj->totalLikes = FacebookApi::getTotalLikes($post);

            $postObj->save();

        }

        $this->saveImage($postId, $postObj);

        $this->logPost($postObj, $action);

    }

    protected function saveImage($postId, $postObj) {
        $targetFile = \System::getContainer()->getParameter('kernel.project_dir') . DIRECTORY_SEPARATOR . $this->imageDir . DIRECTORY_SEPARATOR . $postId . '.jpg';

        $sourceUrl = $postObj->mediaUrl;
        $sourceData = $this->file_get_contents_curl($sourceUrl);

        file_put_contents($targetFile, $sourceData);
    }

    protected function file_get_contents_curl($url) {
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_URL, $url);

        $data = curl_exec($ch);
        curl_close($ch);

        return $data;
    }

    protected function logRun() {
        if ($this->config['command']) {
            $entryStr = sprintf('%s - Facebook Feed: %s', date('d.m.Y H:i:s'), $this->account->accountName);
            echo $entryStr . "\n";
        }
    }

    protected function logPost($postObj, $action) {
        if ($this->config['command'] && $this->config['output']) {
            $entryStr = sprintf('%s [%s] - %s / %s / %s', date('d.m.Y H:i:s'), $action, $this->account->accountName, $postObj->id, substr($postObj->message, 0, 40));
            echo $entryStr . "\n";
        }
    }
}
