<?php

namespace Dmkzwo\ContaoSocialmediaBundle\Classes;

use Abraham\TwitterOAuth\TwitterOAuth;

class TwitterApi
{
    private $twitterConsumerKey;
    private $twitterConsumerSecret;
    private $twitterAccessToken;
    private $twitterAccessTokenSecret;
    private $queryParam;

//    private $user;
//    private $accessToken;
//
    protected $twitterAccessDataFound = false;
    protected $twitterSession;

    /**
     * InstagramApi constructor.
     * @param $params
     */
    public function __construct($params)
    {
        $this->twitterConsumerKey = $params['twitterConsumerKey'];
        $this->twitterConsumerSecret = $params['twitterConsumerSecret'];
        $this->twitterAccessToken = $params['twitterAccessToken'];
        $this->twitterAccessTokenSecret = $params['twitterAccessTokenSecret'];
        $this->queryParam = $params['queryParam'];

        if (strlen($this->twitterConsumerKey) && ($this->twitterConsumerSecret) && ($this->twitterAccessToken) && ($this->twitterAccessTokenSecret) && ($this->queryParam)) {
            $this->twitterAccessDataFound = true;

            $this->twitterSession = new TwitterOAuth($this->twitterConsumerKey, $this->twitterConsumerSecret, $this->twitterAccessToken, $this->twitterAccessTokenSecret);
//    $connection->host = "https://api.twitter.com/1.1/";

        } else {
            $this->twitterSession = false;
        }

    }

    public function getFeeds() {

        $queryStr = $this->queryParam;

        if ($this->isTwitterSearch()) {
            $queryStr = str_replace(' ', '', $queryStr);
            $queryStr = str_replace(',', ' OR ',$queryStr);

            $queryStr .= '-filter:retweets';
            //echo $params;
            //echo '<br>';
            //echo urlencode($params);

            $tempEntries = $this->twitterSession->get('search/tweets', array('q' => $queryStr));
            $entries = $tempEntries->statuses;

        } else {
            $entries = $this->twitterSession->get('statuses/user_timeline', array('screen_name' => $queryStr));

        }

        return $entries;

    }


    protected function isTwitterSearch() {
        return (strpos($this->queryParam, '#') !== false);
    }

    public function getPath($post) {
        if ($this->isTwitterSearch()) {
            $path = TwitterApi::getUserScreenName($post);
        } else {
            $path = $this->queryParam;
        }

        return $path;
    }

    public static function getId($post) {
        return $post->id_str;
    }

    public static function getUnixTimestamp($post) {
        return $post->created_at;
    }

    public static function getCreatedTime($post) {
        return strtotime($post->created_at);
    }

    public static function getUserName($post) {
        if (self::isRetweet($post)) {
            return $post->retweeted_status->user->name;
        } else {
            return $post->user->name;
        }
    }

    public static function getUserScreenName($post) {
            if (self::isRetweet($post)) {
                return strip_tags($post->retweeted_status->text);
            } else {
                return $post->retweeted_status->user->screen_name;
            }
    }

    public static function getMessage($post) {
        if (self::isRetweet($post)) {
            return strip_tags($post->retweeted_status->text);
        } else {
            return strip_tags($post->text);
        }
    }

//$id = $entry->id_str;
//$name = $entry->user->name;
//$screenName = $entry->user->screen_name;
//$text = strip_tags($entry->text);
//$imgSrc = str_replace('http:', 'https:', $entry->user->profile_image_url);
//$date = $this->formatTimestamp($tstamp);

//    public function getId($entry) {
//        return $entry->id_str;
//    }

//    public function getFeeds()
//    {
//
//        if (!$this->facebookAccessDataFound) {
//            return array();
//        }
//
//        try {
//            $userPosts = $this->facebookSession->get(
////                "/" . $params . "/posts?limit=20&fields=id,created_time,attachments,likes,comments",
//                "/" . $this->queryParam . "/feed?limit=20&fields=id,created_time,attachments,likes",
//                $this->accessToken
//            );
//
//            $postBody = $userPosts->getDecodedBody();
//            $allEntries = $postBody["data"];
//
//        } catch (FacebookResponseException $e) {
//            // display error message
//            exit();
//        } catch (FacebookSDKException $e) {
//
//            // display error message
//            exit();
//        }
//
////        var_dump($allEntries);
////        echo sizeof($allEntries);
//
//
//        $entries = array();
//
//        foreach ($allEntries as $entry) {
////            $propertyNames = $entry->getPropertyNames();
//            $propertyNames = array_keys($entry);
////            var_dump($propertyNames);
//
//            $entry['postEntry'] = $this->getPost($entry);
//
//            $totalLikes = 0;
//            if (in_array('story', $propertyNames)) {
//                echo 'story found -------------------------<br>';
//                continue;
//            } else {
//                $totalLikes = $this->getTotalLikesForPost($entry);
//            }
//            $entry['totalLikes'] = $totalLikes;
//
//            $entries[] = $entry;
//
////            echo '<pre>';
////            var_dump($entry);
////            echo '</pre>';
//        }
//
////        var_dump($entries);
////        die();
//
////        echo sizeof($entries);
////        die();
//
//
//        return $entries;
//
//    }
//
//
//    public function getId($arrEntry)
//    {
//        return $arrEntry['id'];
//    }
//
//    public function getUnixTimestamp($arrEntry)
//    {
//        return strtotime($arrEntry['created_time']);
//    }
//
//    public function getTotalLikesForPost($entry)
//    {
//        $likeCount = 0;
//
//        try {
//            $userPosts = $this->facebookSession->get(
//                "/" . $entry['id'] . "/likes?summary=total_count",
//                $this->accessToken
//            );
//
//            $postBody = $userPosts->getDecodedBody();
//            $likeCount = $postBody['summary']['total_count'];
//
////            var_dump($postBody);
////            die();
//
//        } catch (FacebookResponseException $e) {
//        } catch (FacebookSDKException $e) {
//        } catch (\Exception $e) {
//            //echo $e->getMessage();
//        }
//
//        return $likeCount;
//    }
//
//
//    public function getPost($entry)
//    {
//        try {
//            $userPosts = $this->facebookSession->get(
//                "/" . $entry['id'],
//                $this->accessToken
//            );
//
//            $postBody = $userPosts->getDecodedBody();
//
//
////            var_dump($postBody);
////            die();
//
//        } catch (FacebookResponseException $e) {
//        } catch (FacebookSDKException $e) {
//        }
//
//        return $postBody;
//    }
//
    public static function isRetweet($post) {
        return ($post->retweeted_status != null);
    }

    public static function getPicture($post)
    {
        if (self::isRetweet($post)) {
            return $post->retweeted_status->user->profile_image_url_https;
        } else {
            return str_replace('http:', 'https:', $post->user->profile_image_url);
        }

    }

//    public static function getMessage($post)
//    {
//        return $post['postEntry']['message'];
//    }
//
//    public static function getTotalLikes($post)
//    {
//        return $post['totalLikes'];
//    }
//
//    public static function getCreatedTime($post)
//    {
//        return strtotime($post['created_time']);
//    }
//
//    public static function getPermaLink($post)
//    {
//        return 'https://www.facebook.com/' . str_replace('_', '/posts/', $post['id']);
//    }
//
//    protected function getLikes($entry)
//    {
////        echo '<pre>';
////        var_dump($entry['likes']);
////        echo '</pre>';
//
//        $likes = $this->getValue($entry['likes'], 'data');
//
//        if (is_array($likes)) {
//            return sizeof($likes);
//        }
//
//        return 0;
//    }
//
//    protected static function getValue($baseArr, $key)
//    {
//        if (
//            is_array($baseArr) &&
//            array_key_exists($key, $baseArr)
//        ) {
//            return $baseArr[$key];
//        }
//
//        return '';
//    }

}
