<?php

namespace Dmkzwo\ContaoSocialmediaBundle\Classes;


class InstagramApi
{
//    private $appId;
//    private $appSecret;

    private $user;
    private $accessToken;

    /**
     * InstagramApi constructor.
     * @param $params
     */
    public function __construct($params)
    {
//        $this->appId = \System::getContainer()->getParameter('instagram.api_id');
//        $this->appSecret = \System::getContainer()->getParameter('instagram.api_secret');
        $this->apiBaseUrl = \System::getContainer()->getParameter('instagram.api_base_url');
        $this->graphBaseUrl = \System::getContainer()->getParameter('instagram.graph_base_url');

//        $this->appId = $params['appId'];
//        $this->appSecret = $params['appSecret'];
        $this->accessToken = $params['accessToken'];

        $this->user = $this->getUser();
    }

    public function getUser() {
        $params = array(
            'endpoint_url' => $this->graphBaseUrl . 'me',
            'type' => 'GET',
            'url_params' => array(
                'fields' => 'id,username,media_count,account_type'
            )
        );

        $response = $this->makeApiCall($params);

        return $response;
    }

    public function getUserId() {
        return $this->user['id'];
    }

    public function getAccountName() {
        return $this->user['username'];
    }

    public function getUserPosts() {
        $params = array(
            'endpoint_url' => $this->graphBaseUrl . $this->user['id'] . '/media',
            'type' => 'GET',
            'url_params' => array(
                'fields' => 'id,caption,media_type,media_url,permalink,timestamp,thumbnail_url'
            )
        );

        $response = $this->makeApiCall($params);

        return $response;
    }

    public function getUserProfilePicture() {
        $params = array(
            'endpoint_url' => $this->graphBaseUrl . $this->user['id'] . '/picture',
            'type' => 'GET',
            'url_params' => array(
                'redirect' => '0'
            )
        );

        $response = $this->makeApiCall($params);

        return $response;
    }

    protected function makeApiCall($params) {
        $ch = curl_init();

        $endpointUrl = $params['endpoint_url'];

        if ('POST' == $params['type']) {
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($params['url_params']));
            curl_setopt($ch, CURLOPT_POST, 1);

        } elseif ('GET' == $params['type']) {
            $params['url_params']['access_token'] = $this->accessToken;

            $endpointUrl .= '?' . http_build_query($params['url_params']);
        }

        curl_setopt($ch, CURLOPT_URL, $endpointUrl);

        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $response = curl_exec($ch);

        curl_close($ch);

//        echo $response;
//        echo '<br><br>';

        $responseArr = json_decode($response, true);

        if (isset($responseArr['error'])) {
//                        var_dump($responseArr);
//            die();
            throw new \Exception($responseArr['error']['message']);

        } else {
            return $responseArr;
        }
    }
}
