<?php

namespace Dmkzwo\ContaoSocialmediaBundle\Classes;

use Facebook\Facebook;

class FacebookApi
{
    private $appId;
    private $appSecret;
    private $queryParam;

    private $user;
    private $accessToken;

    protected $facebookAccessDataFound = false;
    protected $facebookSession;

    /**
     * InstagramApi constructor.
     * @param $params
     */
    public function __construct($params)
    {
        $this->appId = $params['appId'];
        $this->appSecret = $params['appSecret'];
        $this->accessToken = $params['accessToken'];
        $this->queryParam = $params['queryParam'];

        if (strlen($this->appId) && ($this->appSecret) && ($this->accessToken)) {
            $this->facebookAccessDataFound = true;

            $graphVersion = \System::getContainer()->getParameter('facebook.graph_version');

            $fb = new Facebook([
                'app_id' => $this->appId,
                'app_secret' => $this->appSecret,
                'default_graph_version' => $graphVersion,
            ]);

            $fb->setDefaultAccessToken($this->accessToken);

            $this->facebookSession = $fb;

        } else {
            $this->facebookSession = false;
        }

    }

    public function getFeeds()
    {

        if (!$this->facebookAccessDataFound) {
            return array();
        }

        try {
            $userPosts = $this->facebookSession->get(
//                "/" . $params . "/posts?limit=20&fields=id,created_time,attachments,likes,comments",
                "/" . $this->queryParam . "/feed?limit=20&fields=id,created_time,attachments,likes",
                $this->accessToken
            );

            $postBody = $userPosts->getDecodedBody();
            $allEntries = $postBody["data"];

        } catch (FacebookResponseException $e) {
            // display error message
            exit();
        } catch (FacebookSDKException $e) {

            // display error message
            exit();
        }

//        var_dump($allEntries);
//        echo sizeof($allEntries);


        $entries = array();

        foreach ($allEntries as $entry) {
//            $propertyNames = $entry->getPropertyNames();
            $propertyNames = array_keys($entry);
//            var_dump($propertyNames);

            $entry['postEntry'] = $this->getPost($entry);

            $totalLikes = 0;
            if (in_array('story', $propertyNames)) {
                echo 'story found -------------------------<br>';
                continue;
            } else {
                $totalLikes = $this->getTotalLikesForPost($entry);
            }
            $entry['totalLikes'] = $totalLikes;

            $entries[] = $entry;

//            echo '<pre>';
//            var_dump($entry);
//            echo '</pre>';
        }

//        var_dump($entries);
//        die();

//        echo sizeof($entries);
//        die();


        return $entries;

    }


    public function getId($arrEntry)
    {
        return $arrEntry['id'];
    }

    public function getUnixTimestamp($arrEntry)
    {
        return strtotime($arrEntry['created_time']);
    }

    public function getTotalLikesForPost($entry)
    {
        $likeCount = 0;

        try {
            $userPosts = $this->facebookSession->get(
                "/" . $entry['id'] . "/likes?summary=total_count",
                $this->accessToken
            );

            $postBody = $userPosts->getDecodedBody();
            $likeCount = $postBody['summary']['total_count'];

//            var_dump($postBody);
//            die();

        } catch (FacebookResponseException $e) {
        } catch (FacebookSDKException $e) {
        } catch (\Exception $e) {
            //echo $e->getMessage();
        }

        return $likeCount;
    }


    public function getPost($entry)
    {
        try {
            $userPosts = $this->facebookSession->get(
                "/" . $entry['id'],
                $this->accessToken
            );

            $postBody = $userPosts->getDecodedBody();


//            var_dump($postBody);
//            die();

        } catch (FacebookResponseException $e) {
        } catch (FacebookSDKException $e) {
        }

        return $postBody;
    }


//    public function formatEntry($tstamp, $arrEntry)
//    {
//        $entry = $arrEntry;
//
//        if (!isset($entry) || (!$entry)) {
//            return '';
//        }
//
//        $postId = $entry['id'];
//
////        $likesCount = $this->getLikes($entry);
//        $likesCount = $entry['totalLikes'];
//        $commentsCount = 0;
//
//        $postHref = 'https://www.facebook.com/' . str_replace('_', '/posts/', $postId);
//        $url = '<p><a href="' . $postHref . '" target="_blank">' . $GLOBALS['TL_LANG']['dzsocialmedia']['more_facebook'] . '</a></p>';
//
//        $commentLabel = ($commentsCount > 1) ? $GLOBALS['TL_LANG']['dzsocialmedia']['comments'] : $GLOBALS['TL_LANG']['dzsocialmedia']['comment'];
//        $comments = ($commentsCount > 0) ? '<span class="ce-dz-socialmedia__fbcomment">' . $commentsCount . ' ' . $commentLabel . '</span>' : '';
//
//        $picture = $this->getPicture($entry);
//        $description = $this->getDescription($entry);
//
//        $photo = '';
//        $photoClass = '';
//        if (strlen($picture)) {
//            $photoClass = 'with-image';
//            $photo = '<figure class="image_container"><img src="' . $picture . '" alt="" /></figure>';
//        }
//
//        $output = '
//            <div class="ce-dz-socialmedia__header">
//               <img src="files/framework/img/socmed_icon_facebook.png" alt="Logo Engagement Global" class="ce-dz-socialmedia__image" />
//               ' . $this->formatTimestamp($tstamp) . '
//            </div>
//            <div class="ce-dz-socialmedia__container ' . $photoClass . '">
//              ' . $photo . '
//              <div class="ce-dz-socialmedia__text">
//                <p>' . $this->shortenText($description, 500) . '</p>
//                <div class="ce-dz-socialmedia__footer">
//                  <div><span class="ce-dz-socialmedia__fblike">' . $likesCount . ' Likes</span> ' . $comments . '</div>
//                  ' . $url . '
//                </div>
//              </div>
//            </div>
//            ';
//
//        return $output;
//
//    }

    public static function getPicture($post)
    {
        return self::getValue(
            $post['attachments']['data'][0]['media']['image'],
            'src'
        );
    }

    public static function getMessage($post)
    {
        return $post['postEntry']['message'];
    }

    public static function getTotalLikes($post)
    {
        return $post['totalLikes'];
    }

    public static function getCreatedTime($post)
    {
        return strtotime($post['created_time']);
    }

    public static function getPermaLink($post)
    {
        return 'https://www.facebook.com/' . str_replace('_', '/posts/', $post['id']);
    }

    protected function getLikes($entry)
    {
//        echo '<pre>';
//        var_dump($entry['likes']);
//        echo '</pre>';

        $likes = $this->getValue($entry['likes'], 'data');

        if (is_array($likes)) {
            return sizeof($likes);
        }

        return 0;
    }

    protected static function getValue($baseArr, $key)
    {
        if (
            is_array($baseArr) &&
            array_key_exists($key, $baseArr)
        ) {
            return $baseArr[$key];
        }

        return '';
    }

}
