<?php

namespace Dmkzwo\ContaoSocialmediaBundle\Library;

use Dmkzwo\ContaoSocialmediaBundle\Classes\FacebookApi;
use Dmkzwo\ContaoSocialmediaBundle\Classes\InstagramApi;
use Dmkzwo\ContaoSocialmediaBundle\Model\FacebookAccountModel;
use Dmkzwo\ContaoSocialmediaBundle\Model\InstagramAccountModel;


class SocialmediaUpdater
{
    protected $config;

//    public function __construct($output = false, $log = false)
    public function __construct($config = [])
    {
        $this->config = $config;
//        $this->config = [
//            'output' => $output,
//            'log' => $log,
//        ];
    }


    public function run()
    {
        self::updateInstagramAccounts();
        self::updateFacebookAccounts();
    }

    protected function updateInstagramAccounts()
    {
        $isAccounts = InstagramAccountModel::findBy(['published=?'], ['1']);

        // loop over accounts
        foreach ($isAccounts as $isAccount) {

            // update account
            $params = [
                'appId' => $isAccount->appId,
                'appSecret' => $isAccount->appSecret,
                'accessToken' => $isAccount->accessToken,
            ];

            try {

                $isApi = new InstagramApi($params);

                $isUpdater = new InstagramUpdater($isAccount->id, $isApi, $this->config);
                $isUpdater->run();

            } catch (\Exception $exception) {
                $this->handleError($isAccount, 'Retrieving instagram posts failed', $exception);
            }
        }

    }

    protected function updateFacebookAccounts()
    {
        $fbAccounts = FacebookAccountModel::findBy(['published=?'], ['1']);

        // loop over accounts
        foreach ($fbAccounts as $fbAccount) {

            // update account
            $params = [
                'appId' => $fbAccount->appId,
                'appSecret' => $fbAccount->appSecret,
                'accessToken' => $fbAccount->accessToken,
                'queryParam' => $fbAccount->queryParam,
            ];

            try {
                $fbApi = new FacebookApi($params);

                $fbUpdater = new FacebookUpdater($fbAccount, $fbApi, $this->config);
                $fbUpdater->run();

            } catch (\Exception $exception) {
                $this->handleError($fbAccount, 'Retrieving facebook posts failed', $exception);
            }
        }
    }

    protected function handleError($account, $errMessage, $exception)
    {
        \System::log($errMessage . ': ' . $exception->getMessage(), __METHOD__, TL_ERROR);

        if ($this->config['email'] && !empty($account->notifyOnError) && !$account->notificationDisabled) {
            $emailRecipients = explode(',', preg_replace('/\s+/', '', $account->notifyOnError));

            foreach ($emailRecipients as $emailRecipient) {
                if (\Validator::isEmail($emailRecipient)) {
                    $email = new \Email();
                    $email->subject = $_SERVER['SERVER_NAME'] . ': ' . $errMessage;
                    $email->text = $exception->getMessage();
                    $email->sendTo($emailRecipient);
                }
            }

            $account->notificationDisabled = '1';
            $account->save();
        }
    }
}
