<?php

namespace Dmkzwo\ContaoSocialmediaBundle\Library;

use Dmkzwo\ContaoSocialmediaBundle\Classes\FacebookApi;
use Dmkzwo\ContaoSocialmediaBundle\Classes\InstagramApi;
use Dmkzwo\ContaoSocialmediaBundle\Model\FacebookAccountModel;
use Dmkzwo\ContaoSocialmediaBundle\Model\InstagramAccountModel;


class SocialmediaUpdater
{
    protected $config;

    public function __construct($output = false, $log = false) {
        $this->config = [
            'output' => $output,
            'log' => $log,
        ];
    }


    public function run()
    {
//        self::updateInstagramAccounts();
        self::updateFacebookAccounts();
    }

    protected function updateInstagramAccounts()
    {
        $isAccounts = InstagramAccountModel::findBy(['published=?'], ['1']);

        // loop over accounts
        foreach ($isAccounts as $isAccount) {

            // update account
            $params = [
                'appId' => $isAccount->appId,
                'appSecret' => $isAccount->appSecret,
                'accessToken' => $isAccount->accessToken,
            ];

            $isApi = new InstagramApi($params);

            $isUpdater = new InstagramUpdater($isAccount->id, $isApi, $this->config);
            $isUpdater->run();

        }

    }

    protected function updateFacebookAccounts()
    {
        $fbAccounts = FacebookAccountModel::findBy(['published=?'], ['1']);

        // loop over accounts
        foreach ($fbAccounts as $fbAccount) {

            // update account
            $params = [
                'appId' => $fbAccount->appId,
                'appSecret' => $fbAccount->appSecret,
                'accessToken' => $fbAccount->accessToken,
                'queryParam' => $fbAccount->queryParam,
            ];

            $fbApi = new FacebookApi($params);

            $fbUpdater = new FacebookUpdater($fbAccount, $fbApi, $this->config);
            $fbUpdater->run();
        }
    }

}
