<?php


namespace Dmkzwo\ContaoSocialmediaBundle\Library;


use Dmkzwo\ContaoSocialmediaBundle\Classes\InstagramApi;
use Dmkzwo\ContaoSocialmediaBundle\Model\InstagramAccountModel;
use Dmkzwo\ContaoSocialmediaBundle\Model\InstagramPostModel;

class InstagramUpdater
{
    protected $isApi;
    protected $accountId;

    protected $userId;
    protected $accountName;
    protected $imageDir;

    protected $config;

    /**
     * InstagramUpdater constructor.
     * @param $isApi
     */
    public function __construct($accountId, $isApi, $config = [])
    {
        $this->accountId = $accountId;
        $this->isApi = $isApi;
        $this->config = $config;
        $this->userId = $this->isApi->getUserId();
        $this->accountName = $this->isApi->getAccountName();
    }


    public function run() {
        $this->logRun();

        $this->prepareDirectories();
        $this->updatePosts();
    }

    protected function prepareDirectories() {
        $this->imageDir = \System::getContainer()->getParameter('instagram.social_media_dir') . DIRECTORY_SEPARATOR . $this->userId;

        $directories = [
            $this->imageDir,
        ];

        foreach ($directories as $directory) {
            $dir = \System::getContainer()->getParameter('kernel.project_dir') . DIRECTORY_SEPARATOR . $directory;
            if (!file_exists($dir)) {
                mkdir($dir, 0777, true);
            }
        }
    }

    protected function updatePosts() {
        $posts = $this->isApi->getUserPosts();

        if (!isset($posts['data'])) {
            return;
        }

        if (is_array($posts['data']) && sizeof($posts['data'])) {
            foreach ($posts['data'] as $post) {
                $this->createOrUpdatePost($post);
            }
        }
//        var_dump($posts);
    }

    protected function createOrUpdatePost($post) {
        $mediaId = $post['id'];

        $media = InstagramPostModel::findOneBy('mediaId', $mediaId);

        $action = '';

        if ($media) {
            // update
            $action = 'UPDATE';

            $media->caption = $post['caption'];
            $media->mediaUrl = $post['media_url'];
            $media->mediaType = $post['media_type'];

            $media->save();

        } else {
            // create
            $action = 'CREATE';

            $instagramAccount = InstagramAccountModel::findByPk($this->accountId);

            $newMedia = new InstagramPostModel();

            $newMedia->pid = $this->accountId;
            $newMedia->published = ($instagramAccount->publishMode == 'blacklist') ? '1' : '';
            $newMedia->mediaId = $mediaId;
            $newMedia->accountId = $instagramAccount->accountName;
            $newMedia->userId = $this->userId;
            $newMedia->tstamp = strtotime($post['timestamp']);
            $newMedia->caption = $post['caption'];
            $newMedia->mediaUrl = $post['media_url'];
            $newMedia->mediaType = $post['media_type'];
            $newMedia->permaLink = $post['permalink'];

            $newMedia->save();

        }

        $this->saveImage($mediaId, $post);

        $this->logPost($post, $action);

    }

    protected function saveImage($mediaId, $post) {
        $targetFile = \System::getContainer()->getParameter('kernel.project_dir') . DIRECTORY_SEPARATOR . $this->imageDir . DIRECTORY_SEPARATOR . $mediaId . '.jpg';

        $sourceUrl = ($post['media_type'] == 'VIDEO') ? $post['thumbnail_url'] : $post['media_url'];
        $sourceData = $this->file_get_contents_curl($sourceUrl);

        file_put_contents($targetFile, $sourceData);
    }

    protected function file_get_contents_curl($url) {
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_URL, $url);

        $data = curl_exec($ch);
        curl_close($ch);

        return $data;
    }

    protected function logRun() {
            $entryStr = sprintf('%s - Instagram Feed: %s', date('d.m.Y H:i:s'), $this->accountName);
            echo $entryStr . "\n";
    }

    protected function logPost($post, $action) {
        if ($this->config['output']) {
            $entryStr = sprintf('%s [%s] - %s / %s / %s', date('d.m.Y H:i:s'), $action, $this->accountName, $post['id'], substr($post['caption'], 0, 40));
            echo $entryStr . "\n";
        }
    }
}
