<?php

/*
 * This file is part of [dmkzwo/contao-hello-world-bundle].
 *
 * (c) Dmkzwo
 *
 * @license LGPL-3.0-or-later
 */

namespace Dmkzwo\ContaoSocialmediaBundle\Classes\Cron;

use Contao\CoreBundle\ServiceAnnotation\CronJob;
use Dmkzwo\ContaoSocialmediaBundle\Library\SocialmediaUpdater;


class SocialmediaUpdateCron
{
    /**
     * @CronJob("hourly")
     */
    public function updateFeeds() {
        $cronjobEnabled = \System::getContainer()->hasParameter('dz.socialmedia.cronjob.enabled') && \System::getContainer()->getParameter('dz.socialmedia.cronjob.enabled');

        if ($cronjobEnabled) {
            $command = new SocialmediaUpdater();
            $command->run();
        }
    }
}

