<?php

namespace Dmkzwo\ContaoSocialmediaBundle\Model;

class InstagramAccountModel extends \Model
{
    protected static $strTable = 'tl_dz_socialmedia_instagram';

    public static function findPublishedAccountIds() {
        return self::findByPublished('1')->fetchEach('userId');
    }

    public static function getPublishedAccountOptions() {
        $publishedAccounts = self::findByPublished('1');

        $options = [];

        foreach ($publishedAccounts as $publishedAccount) {
            $options[$publishedAccount->id] = $publishedAccount->accountName;
        }

        return $options;
    }
}

class_alias(InstagramAccountModel::class, 'InstagramAccountModel');
// and if tablename differs from model name:
class_alias(InstagramAccountModel::class, 'DzSocialmediaInstagramModel');
