<?php

namespace Dmkzwo\ContaoQuoteBundle\Elements;

use Contao\ContentModel;
use Contao\FilesModel;
use Contao\Controller;
use Contao\System;
use Contao\CoreBundle\Controller\ContentElement\AbstractContentElementController;
use Contao\CoreBundle\ServiceAnnotation\ContentElement;
use Contao\Template;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * @ContentElement(QuoteElementController::TYPE)
 */
class QuoteElementController extends AbstractContentElementController
{
    public const TYPE = 'quote_element';

    protected $template;
    protected $model;

    protected $baseCssClass = 'ce_dzquote';


    protected function getResponse(Template $template, ContentModel $model, Request $request): ?Response
    {
        $template->baseCssClass = $this->baseCssClass;

//        $keycolor = !empty($model->dzGeneralKeycolor) ? $model->dzGeneralKeycolor : 'standard';
//        $template->keycolorClass = $this->baseCssClass . '--keycolor-' . $keycolor;

        $template->addImage = false;

        // Add an image
        if ($model->addImage && $model->singleSRC != '')
        {
            $objModel = FilesModel::findByUuid($model->singleSRC);

            if ($objModel !== null && is_file(System::getContainer()->getParameter('kernel.project_dir') . '/' . $objModel->path))
            {
                $template->setName('ce_quote_element_with-image');
                $template->addImage = true;
                $template->class .= ' ' . $this->baseCssClass . '--with-image';

                $model->singleSRC = $objModel->path;
                Controller::addImageToTemplate($template, $model->row(), null, null, $objModel);
            }
        }

        return $template->getResponse();
    }


}

