<?php


namespace Dmkzwo\ContaoNewsextBundle\Classes;


use Contao\NewsModel;

class NewsDca extends \System
{

    public static function loadCategories($varValue, \DataContainer $dc)
    {

        $categoryIds = unserialize($varValue);
        $newsId = $dc->id;

        $categoryIds = self::addDefaultCategory($newsId, $categoryIds);

        return serialize($categoryIds);
    }


    public static function saveCategories($varValue, \DataContainer $dc)
    {

        $categoryIds = unserialize($varValue);
        $newsId = $dc->id;

        $categoryIds = self::addDefaultCategory($newsId, $categoryIds);
        self::saveRelCategories($newsId, $categoryIds);

        return serialize($categoryIds);
    }


    protected static function saveRelCategories($newsId, $categoryIds) {
        \Database::getInstance()->prepare("DELETE FROM tl_dz_news_category_rel WHERE newsId=?")->execute($newsId);

        foreach ($categoryIds as $categoryId) {
            \Database::getInstance()->prepare("INSERT INTO tl_dz_news_category_rel (newsId, categoryId) VALUES (?,?)")->execute($newsId, $categoryId);
        }
    }

    /**
     * @param int $newsId
     * @param array $categoryIds
     * @return array
     */
    protected static function addDefaultCategory(int $newsId, $categoryIds): array
    {
        if (!is_array($categoryIds)) {
            $categoryIds = [];
        }

        $news = NewsModel::findByPk($newsId);

        if ($news) {
            $archiveId = $news->pid;

            $newsArchive = \NewsArchiveModel::findByPk($archiveId);

            if ($newsArchive) {
                $archiveCategoryId = $newsArchive->dzNewsCategory;

                $categoryIds = array_unique(array_merge($categoryIds, [$archiveCategoryId]));
            }
        }
        return $categoryIds;
    }

}
