<?php

namespace Dmkzwo\ContaoNewsextBundle\Model;


class DzNewsModel extends \NewsModel {

    public static function fetchItems($newsArchives, $blnFeatured, $limit, $offset, $caller) {

        if (strpos(get_class($caller), 'NewsListByCategoryModule')) {

            $categoryId = trim($caller->dzNewsCategory);

            return static::findPublishedByCategoryId($newsArchives, $blnFeatured, $limit, $offset, $categoryId);

        } else {
            // default behavior
            return static::findPublishedByPids($newsArchives, $blnFeatured, $limit, $offset);

        }

    }


    public static function findPublishedByCategoryId($arrPids, $blnFeatured=null, $intLimit=0, $intOffset=0, $categoryId, array $arrOptions=array()) {
        if (!is_array($arrPids) || empty($arrPids))
        {
            return null;
        }

        $t = static::$strTable;
        $arrColumns = array("$t.pid IN(" . implode(',', array_map('intval', $arrPids)) . ")");

        if ($blnFeatured === true)
        {
            $arrColumns[] = "$t.featured='1'";
        }
        elseif ($blnFeatured === false)
        {
            $arrColumns[] = "$t.featured=''";
        }

        // Never return unpublished elements in the back end, so they don't end up in the RSS feed
        if (!BE_USER_LOGGED_IN || TL_MODE == 'BE')
        {
            $time = \Date::floorToMinute();
            $arrColumns[] = "($t.start='' OR $t.start<='$time') AND ($t.stop='' OR $t.stop>'" . ($time + 60) . "') AND $t.published='1'";
        }

        if (strlen($categoryId)) {
            $arrColumns[] = "($t.id in (SELECT DISTINCT newsId FROM tl_dz_news_category_rel WHERE categoryId='".$categoryId."'))";
//            $arrTags = explode(',', $strTags);
//            $tags = array();
//            foreach ($arrTags as $tag) {
//                $tag = trim($tag);
//                if (strlen($tag)) {
//                    $tags[] = "$t.dz_news_tags LIKE '%*".$tag."*%'";
//                }
//            }
//            if (sizeof($tags)) {
//                $arrColumns[] = "(" . implode(" OR ", $tags) . ")";
//            }
        }

        if (!isset($arrOptions['order']))
        {
            $arrOptions['order']  = "$t.date DESC";
        }

        $arrOptions['limit']  = $intLimit;
        $arrOptions['offset'] = $intOffset;

        return static::findBy($arrColumns, null, $arrOptions);

    }

}
