<?php

Contao\System::loadLanguageFile('tl_content');


$GLOBALS['TL_DCA']['tl_dz_news_category'] = array
(

    // Config
    'config' => array
    (
        'dataContainer' => 'Table',
        'enableVersioning' => true,
        'markAsCopy' => 'title',

        'sql' => array
        (
            'keys' => array
            (
                'id' => 'primary',
            )
        )
    ),

    // List
    'list' => array
    (
        'sorting' => array
        (
            'mode' => 5,
            'fields' => array('sorting'),
            'panelLayout' => 'search;filter;limit',
            'disableGrouping' => true,
            'paste_button_callback' => array('tl_dz_news_category', 'pasteElement')
        ),

        'label' => array
        (
            'fields' => array('title_de'),
            'format' => '%s',
        ),

        'global_operations' => array
        (
            'all' => array
            (
                'label' => &$GLOBALS['TL_LANG']['MSC']['all'],
                'href' => 'act=select',
                'class' => 'header_edit_all',
                'attributes' => 'onclick="Backend.getScrollOffset()" accesskey="e"'
            )
        ),

        'operations' => array
        (
            'edit' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_content']['edit'],
                'href' => 'act=edit',
                'icon' => 'edit.svg'
            ),
            'copy' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_content']['copy'],
                'href' => 'act=copy',
                'icon' => 'copy.svg'
            ),
            'cut' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_content']['cut'],
                'href' => 'act=paste&amp;mode=cut',
                'icon' => 'cut.svg'
            ),
            'delete' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_content']['delete'],
                'href' => 'act=delete',
                'icon' => 'delete.svg',
                'attributes' => 'onclick="if(!confirm(\'' . $GLOBALS['TL_LANG']['MSC']['deleteConfirm'] . '\'))return false;Backend.getScrollOffset()"'
            ),
            'toggle' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_dz_news_category']['toggle'],
                'icon' => 'visible.svg',
                'button_callback' => array('tl_dz_news_category', 'toggleIcon'),
                // use ajax
                'attributes' => 'onclick="Backend.getScrollOffset();return AjaxRequest.toggleVisibility(this,%s)"',
            ),
            'show' => array
            (
                'label' => &$GLOBALS['TL_LANG']['tl_content']['show'],
                'href' => 'act=show',
                'icon' => 'show.svg'
            )
        )
    ),

    // Palettes
    'palettes' => array
    (
        'default' => 'title_de,title_en,title_fr,title_es,published'
    ),

    'fields' => array
    (
        'id' => array
        (
            'sql' => "int(10) unsigned NOT NULL auto_increment"
        ),
        'pid' => array
        (
            'sql' => "int(10) unsigned NOT NULL default 0"
        ),
        'sorting' => array
        (
            'label' => &$GLOBALS['TL_LANG']['MSC']['sorting'],
            'sorting' => false,
            'flag' => 2,
            'sql' => "int(10) unsigned NOT NULL default 0"
        ),
        'tstamp' => array
        (
            'sql' => "int(10) unsigned NOT NULL default 0"
        ),
        'published' => array
        (
            // If true the field will be excluded for non-admins. It can be enabled in the user group module (allowed excluded fields).
            // false = default
            'exclude' => true,

            'filter' => true,
            'inputType' => 'checkbox',
            'eval' => array('doNotCopy' => true, 'tl_class' => 'w50'),
            'sql' => "char(1) NOT NULL default '1'"
        ),

        'title_de' => array
        (
            'exclude' => false,
            'inputType' => 'text',
            'eval' => array('mandatory' => true, 'maxlength' => 255, 'tl_class' => 'clr long'),
            'sql' => "varchar(255) NOT NULL default ''"
        ),

        'title_en' => array
        (
            'exclude' => false,
            'inputType' => 'text',
            'eval' => array('mandatory' => true, 'maxlength' => 255, 'tl_class' => 'clr long'),
            'sql' => "varchar(255) NOT NULL default ''"
        ),

        'title_fr' => array
        (
            'exclude' => false,
            'inputType' => 'text',
            'eval' => array('mandatory' => true, 'maxlength' => 255, 'tl_class' => 'clr long'),
            'sql' => "varchar(255) NOT NULL default ''"
        ),

        'title_es' => array
        (
            'exclude' => false,
            'inputType' => 'text',
            'eval' => array('mandatory' => true, 'maxlength' => 255, 'tl_class' => 'clr long'),
            'sql' => "varchar(255) NOT NULL default ''"
        ),

    )
);


class tl_dz_news_category extends Contao\Backend
{

    /**
     * Import the back end user object
     */
    public function __construct()
    {
        parent::__construct();
        $this->import('Contao\BackendUser', 'User');
    }


    public function customLabel($row, $label)
    {
        // $label is already formatted according to the format attribute

        $label = sprintf('<strong>%s</strong> ', $row['id']) . $label;

        return $label;
    }

    public function toggleIcon($row, $href, $label, $title, $icon, $attributes)
    {
        if (strlen(Input::get('tid'))) {
            $this->toggleVisibility(Input::get('tid'), (Input::get('state') == 1));
            $this->redirect($this->getReferer());
        }

        $href .= '&tid=' . $row['id'] . '&state=' . ($row['published'] ? 0 : 1);

        if (!$row['published']) {
            $icon = 'invisible.gif';
        }

        return '<a href="' . $this->addToUrl($href) . '" title="' . specialchars($title) . '" ' . $attributes . '>' . Image::getHtml($icon, $label, 'data-state="' . ($row['published'] ? 1 : 0) . '"') . '</a> ';
    }

    public function toggleVisibility($id, $isVisible)
    {
        $post = \Dmkzwo\ContaoDzDevTemplateBundle\Model\ListSimpleModel::findByPk($id);
        $post->published = $isVisible ? 1 : 0;
        $post->save();
    }

    /**
     * Check permissions to edit table tl_dz_news_category
     */
//    public function checkPermission()
//    {
//        $bundles = Contao\System::getContainer()->getParameter('kernel.bundles');
//
//    }

    public function pasteElement(DataContainer $dc, $row, $table, $cr, $arrClipboard)
    {
        $imagePasteAfter = Image::getHtml('pasteafter.gif', sprintf($GLOBALS['TL_LANG'][$table]['pasteafter'][1], $row['id']));
        return '<a href="' . $this->addToUrl('act=' . $arrClipboard['mode'] . '&mode=1&pid=' . $row['id']) . '" title="' . specialchars(sprintf($GLOBALS['TL_LANG'][$table]['pasteafter'][1],
                $row['id'])) . '" onclick="Backend.getScrollOffset()">' . $imagePasteAfter . '</a> ';
    }

}
