<?php


namespace Dmkzwo\ContaoNewsextBundle\Classes;



use Contao\NewsModel;
use Dmkzwo\ContaoNewsextBundle\Model\NewsCategoryModel;

class NewsCategory extends \System
{

    public static function getCategories() {
        $categories = [];

        $newsCategories = NewsCategoryModel::findByPublished('1', [
            'order' => 'sorting'
        ]);

        foreach ($newsCategories as $newsCategory) {
            $titleProperty = 'title_' . $GLOBALS['TL_LANGUAGE'];
            $categories[$newsCategory->id] = $newsCategory->$titleProperty;
        }

        return $categories;
    }

    public static function getCategoryLabelById($categoryId) {
        $newsCategory = NewsCategoryModel::findByPk($categoryId);

        if ($newsCategory) {
            $titleProperty = 'title_' . $GLOBALS['TL_LANGUAGE'];
            return $newsCategory->$titleProperty;
        }

        return '';
    }

    public static function getArchivCategoryIdByNewsId($newsId) {
        $news = NewsModel::findByPk($newsId);

        if ($news) {
            $archiveId = $news->pid;

            $newsArchive = \NewsArchiveModel::findByPk($archiveId);

            if ($newsArchive) {

                return $newsArchive->dzNewsCategory;
            }
        }

        return false;
    }

}
