<?php


namespace Dmkzwo\ContaoNewsextBundle\Classes;



use Contao\NewsModel;

class NewsCategory extends \System
{

    public static function getCategoryKeys() {
        return range(1, 5);
    }

    public static function getCategories() {
        $categories = [];

        $categoryKeys = self::getCategoryKeys();

        foreach ($categoryKeys as $categoryKey) {
            $categories[$categoryKey] = $GLOBALS['TL_LANG']['dz_newsext']['category'][strval($categoryKey)];
        }

        return $categories;
    }

    public static function getCategoryLabelById($categoryId) {
        return $GLOBALS['TL_LANG']['dz_newsext']['category'][strval($categoryId)];
    }

    public static function getArchivCategoryIdByNewsId($newsId) {
        $news = NewsModel::findByPk($newsId);

        if ($news) {
            $archiveId = $news->pid;

            $newsArchive = \NewsArchiveModel::findByPk($archiveId);

            if ($newsArchive) {

                return $newsArchive->dzNewsCategory;
            }
        }

        return false;
    }

}
