<?php

declare(strict_types=1);

/*
 * This file is part of dmkzwo/contao-layout-bundle.
 *
 * (c) Dmkzwo GmbH
 *
 * @license proprietary
 */

$GLOBALS['TL_DCA']['tl_article']['palettes']['default'] = str_replace(';{layout_legend}',
    ';{dz_style_legend},dzFullwidth,dzPaddingtop,dzPaddingbottom,dzBgSrc,dzBgDarken,dzBgCopyright,dzBgColor,dzAddCustomBgColor,dzOverlap,dzTheme;{layout_legend}',
    $GLOBALS['TL_DCA']['tl_article']['palettes']['default']);

$GLOBALS['TL_DCA']['tl_article']['palettes']['__selector__'][] = 'dzAddCustomBgColor';

$GLOBALS['TL_DCA']['tl_article']['subpalettes']['dzAddCustomBgColor'] = 'dzCustomBgColor';

$GLOBALS['TL_DCA']['tl_article']['fields']['dzFullwidth'] = [
    'label' => &$GLOBALS['TL_LANG']['tl_article']['dzFullwidth'],
    'exclude' => false,
    'sorting' => false,
    'inputType' => 'checkbox',
    'default' => '',
    'eval' => ['tl_class' => 'w50'],
    'sql' => "char(1) NOT NULL default ''",
];

$GLOBALS['TL_DCA']['tl_article']['fields']['dzPaddingtop'] = [
    'label' => &$GLOBALS['TL_LANG']['tl_article']['dzPaddingtop'],
    'exclude' => false,
    'search' => false,
    'filter' => false,
    'inputType' => 'select',
    'options_callback' => [
        '\\Dmkzwo\\ContaoLayoutBundle\\Classes\\ArticleDca',
        'getPaddingtopBackendOptions',
    ],
    'eval' => ['tl_class' => 'clr w50'],
    'sql' => "varchar(128) NOT NULL default 'standard'",
];

$GLOBALS['TL_DCA']['tl_article']['fields']['dzPaddingbottom'] = [
    'label' => &$GLOBALS['TL_LANG']['tl_article']['dzPaddingbottom'],
    'exclude' => false,
    'search' => false,
    'filter' => false,
    'inputType' => 'select',
    'options_callback' => [
        '\\Dmkzwo\\ContaoLayoutBundle\\Classes\\ArticleDca',
        'getPaddingbottomBackendOptions',
    ],
    'eval' => ['tl_class' => 'w50'],
    'sql' => "varchar(128) NOT NULL default 'standard'",
];

$GLOBALS['TL_DCA']['tl_article']['fields']['dzBgSrc'] = [
    'label' => &$GLOBALS['TL_LANG']['tl_article']['dzBgSrc'],
    'exclude' => false,
    'search' => false,
    'filter' => false,
    'inputType' => 'fileTree',
    'eval' => ['filesOnly' => true, 'fieldType' => 'radio', 'mandatory' => false, 'tl_class' => 'clr w50'],
    'sql' => 'binary(16) NULL',
];

$GLOBALS['TL_DCA']['tl_article']['fields']['dzBgCopyright'] = [
    'exclude' => false,
    'search' => false,
    'filter' => false,
    'inputType' => 'text',
    'eval' => ['tl_class' => 'clr long'],
    'sql' => "varchar(255) NOT NULL default ''",
];

$GLOBALS['TL_DCA']['tl_article']['fields']['dzBgDarken'] = [
    'exclude' => false,
    'search' => false,
    'filter' => false,
    'inputType' => 'checkbox',
    'eval' => ['tl_class' => 'w50'],
    'sql' => "char(1) NOT NULL default ''",
];

$GLOBALS['TL_DCA']['tl_article']['fields']['dzBgColor'] = [
    'exclude' => false,
    'search' => false,
    'filter' => false,
    'inputType' => 'select',
    'options_callback' => [
        '\\Dmkzwo\\ContaoLayoutBundle\\Classes\\ArticleDca',
        'getBackgroundColorBackendOptions',
    ],
    'eval' => ['tl_class' => 'clr w50'],
    'sql' => "varchar(128) NOT NULL default 'standard'",
];

$GLOBALS['TL_DCA']['tl_article']['fields']['dzAddCustomBgColor'] = [
    'exclude' => false,
    'search' => false,
    'filter' => false,
    'inputType' => 'checkbox',
    'eval' => ['tl_class' => 'clr w50', 'submitOnChange'=>true],
    'sql' => "char(1) NOT NULL default ''",
];

$GLOBALS['TL_DCA']['tl_article']['fields']['dzCustomBgColor'] = [
    'inputType' => 'text',
    'eval' => ['maxlength' => 6, 'colorpicker' => true, 'isHexColor' => true, 'decodeEntities' => true, 'tl_class' => 'w50 wizard'],
    'sql' => "varchar(64) NOT NULL default ''"
];

$GLOBALS['TL_DCA']['tl_article']['fields']['dzOverlap'] = [
    'exclude' => false,
    'search' => false,
    'filter' => false,
    'inputType' => 'select',
    'options_callback' => [
        '\\Dmkzwo\\ContaoLayoutBundle\\Classes\\ArticleDca',
        'getOverlapBackendOptions',
    ],
    'eval' => ['tl_class' => 'clr w50'],
    'sql' => "varchar(128) NOT NULL default 'none'",
];

$GLOBALS['TL_DCA']['tl_article']['fields']['dzTheme'] = [
    'exclude' => false,
    'search' => false,
    'filter' => false,
    'inputType' => 'select',
    'options_callback' => [
        '\\Dmkzwo\\ContaoLayoutBundle\\Classes\\ArticleDca',
        'getThemeBackendOptions',
    ],
    'eval' => ['tl_class' => 'clr w50'],
    'sql' => "varchar(128) NOT NULL default 'standard'",
];
