<?php

declare(strict_types=1);

/*
 * This file is part of dmkzwo/contao-layout-bundle.
 *
 * (c) Dmkzwo GmbH
 *
 * @license proprietary
 */

namespace Dmkzwo\ContaoLayoutBundle\DependencyInjection;

use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Extension\Extension;
use Symfony\Component\DependencyInjection\Loader\YamlFileLoader;

class ContaoLayoutExtension extends Extension
{
    /**
     * {@inheritdoc}
     */
    public function load(array $mergedConfig, ContainerBuilder $container): void
    {
        $loader = new YamlFileLoader(
            $container,
            new FileLocator(__DIR__.'/../Resources/config')
        );

        $loader->load('services.yml');
        $loader->load('config.yml');
    }
}
