<?php

declare(strict_types=1);

/*
 * This file is part of dmkzwo/contao-layout-bundle.
 *
 * (c) Dmkzwo GmbH
 *
 * @license proprietary
 */

namespace Dmkzwo\ContaoLayoutBundle\Library;

use Contao\FilesModel;
use Contao\System;

class Inserttags
{
    public function myReplaceInsertTags(string $strTag)
    {
        $arrSplit = explode('::', $strTag);

        if ('bgimage' === $arrSplit[0]) {
            if (!$arrSplit[1]) {
                return '';
            }

            $fileSrc = $arrSplit[1];

            $objModel = FilesModel::findByUuid($fileSrc);

            if (null !== $objModel && is_file(System::getContainer()->getParameter('kernel.project_dir').'/'.$objModel->path)) {
                return " background-image: url('".rawurldecode($objModel->path)."'); ";
            }

            return '';
        }

        return false; // this is important!!!
    }
}
