<?php

declare(strict_types=1);

/*
 * This file is part of dmkzwo/contao-layout-bundle.
 *
 * (c) Dmkzwo GmbH
 *
 * @license proprietary
 */

namespace Dmkzwo\ContaoLayoutBundle\Classes;

use Contao\System;
use Dmkzwo\ContaoLayoutBundle\Library\YamlHelper;
use Symfony\Component\Yaml\Yaml;

class ContentDca
{
    public function getLegacyMarginOptions(): array
    {
        return [
            'content-margin-none' => 'kein Abstand',
            'content-margin-standard' => 'Standard Abstand',
            'content-margin-small' => 'Medium Abstand',
            'content-margin-large' => 'großer Abstand',
        ];
    }

    public function getMarginOptions(): array
    {
        $options = YamlHelper::getOptionsFromFile('cemargin', 'cemargins');

        if (empty($options)) {
            $options = $this->getLegacyMarginOptions();
        } else {
            // check for default
            if (!array_key_exists('content-margin-standard', $options)) {
                $options = ['content-margin-standard' => 'Standard'];
            }
        }

        return $options;
    }

    public function getGeneralKeycolorBackendOptions(): array
    {
        $options = YamlHelper::getOptionsFromFile('keycolor', 'keycolors');

        if (empty($options)) {
            $options = ['standard' => 'Standard'];
        }

        return $options;
    }

    public function getGeneralBgcolorBackendOptions(): array
    {
        $options = YamlHelper::getOptionsFromFile('bgcolor', 'bgcolors');

        if (empty($options)) {
            $options = ['standard' => 'Standard'];
        }

        return $options;
    }

    public function adjustPalette($dc): void
    {
        $additionalFields = self::getAdditionalFields();

        foreach ($additionalFields as $typName => $fieldNames) {
            if (\count($fieldNames)) {
                if (false !== strpos($GLOBALS['TL_DCA']['tl_content']['palettes'][$typName], 'dzSubtype')) {
                    $GLOBALS['TL_DCA']['tl_content']['palettes'][$typName] = str_replace(
                        ',dzSubtype',
                        ',dzSubtype,'.implode(',', $fieldNames),
                        $GLOBALS['TL_DCA']['tl_content']['palettes'][$typName]
                    );
                } else {
                    $GLOBALS['TL_DCA']['tl_content']['palettes'][$typName] = str_replace(
                        ',type',
                        ',type,'.implode(',', $fieldNames),
                        $GLOBALS['TL_DCA']['tl_content']['palettes'][$typName]
                    );
                }
            }
//            echo $typName . ' ' . $GLOBALS['TL_DCA']['tl_content']['palettes'][$typName];
//            echo '<br><br>';
        }
    }

    protected static function getAdditionalFields(): array
    {
        $additionalFields = [];

        $marginElements = Settings::getMarginElements();

        foreach ($marginElements as $key) {
            if (!\array_key_exists($key, $additionalFields)) {
                $additionalFields[$key] = ['dzMarginContent'];
            } else {
                $additionalFields[$key][] = 'dzMarginContent';
            }
        }

        $keycolorElements = Settings::getKeycolorElements();

        foreach ($keycolorElements as $key) {
            if (!\array_key_exists($key, $additionalFields)) {
                $additionalFields[$key] = ['dzGeneralKeycolor'];
            } else {
                $additionalFields[$key][] = 'dzGeneralKeycolor';
            }
        }

        $bgcolorElements = Settings::getBgcolorElements();

        foreach ($bgcolorElements as $key) {
            if (!\array_key_exists($key, $additionalFields)) {
                $additionalFields[$key] = ['dzGeneralBgcolor'];
            } else {
                $additionalFields[$key][] = 'dzGeneralBgcolor';
            }
        }

        $bgsrcElements = Settings::getBgsrcElements();

        foreach ($bgsrcElements as $key) {
            if (!\array_key_exists($key, $additionalFields)) {
                $additionalFields[$key] = ['dzGeneralBgSrc, dzBgDarken'];
            } else {
                $additionalFields[$key][] = 'dzGeneralBgSrc, dzBgDarken';
            }
        }

//        var_dump($additionalFields);

        return $additionalFields;
    }
}
