<?php

declare(strict_types=1);

/*
 * This file is part of dmkzwo/contao-layout-bundle.
 *
 * (c) Dmkzwo GmbH
 *
 * @license proprietary
 */

$GLOBALS['TL_DCA']['tl_content']['config']['onload_callback'][] = [
    'Dmkzwo\\ContaoLayoutBundle\\Classes\\ContentDca',
    'adjustPalette',
];

$GLOBALS['TL_DCA']['tl_content']['fields']['dzMarginContent'] = [
    'label' => &$GLOBALS['TL_LANG']['tl_content']['dzMarginContent'],
    'search' => false,
    'inputType' => 'select',
    'default' => 'content-margin-standard',
    'options_callback' => ['Dmkzwo\\ContaoLayoutBundle\\Classes\\ContentDca', 'getMarginOptions'],
    'eval' => ['mandatory' => false, 'tl_class' => 'w50'],
    'sql' => "varchar(255) NOT NULL default ''",
];

$GLOBALS['TL_DCA']['tl_content']['fields']['dzGeneralKeycolor'] = [
    'label' => &$GLOBALS['TL_LANG']['tl_content']['dzGeneralKeycolor'],
    'exclude' => false,
    'search' => false,
    'filter' => false,
    'inputType' => 'select',
    'default' => 'standard',
    'options_callback' => [
        '\\Dmkzwo\\ContaoLayoutBundle\\Classes\\ContentDca',
        'getGeneralKeycolorBackendOptions',
    ],
    'eval' => ['tl_class' => 'clr w50'],
    'sql' => "varchar(128) NOT NULL default 'standard'",
];

$GLOBALS['TL_DCA']['tl_content']['fields']['dzGeneralBgcolor'] = [
    'label' => &$GLOBALS['TL_LANG']['tl_content']['dzGeneralBgcolor'],
    'exclude' => false,
    'search' => false,
    'filter' => false,
    'inputType' => 'select',
    'default' => 'standard',
    'options_callback' => [
        '\\Dmkzwo\\ContaoLayoutBundle\\Classes\\ContentDca',
        'getGeneralBgcolorBackendOptions',
    ],
    'eval' => ['tl_class' => 'clr w50'],
    'sql' => "varchar(128) NOT NULL default 'standard'",
];

$GLOBALS['TL_DCA']['tl_content']['fields']['dzGeneralBgSrc'] = [
    'label' => &$GLOBALS['TL_LANG']['tl_content']['dzGeneralBgSrc'],
    'exclude' => true,
    'inputType' => 'fileTree',
    'eval' => ['filesOnly' => true, 'fieldType' => 'radio', 'mandatory' => false, 'tl_class' => 'clr w50'],
    'sql' => 'binary(16) NULL',
];

$GLOBALS['TL_DCA']['tl_content']['fields']['dzBgDarken'] = [
    'exclude' => false,
    'search' => false,
    'filter' => false,
    'inputType' => 'checkbox',
    'eval' => ['tl_class' => 'w50'],
    'sql' => "char(1) NOT NULL default ''",
];
