<?php

declare(strict_types=1);

/*
 * This file is part of dmkzwo/contao-layout-bundle.
 *
 * (c) Dmkzwo GmbH
 *
 * @license proprietary
 */

namespace Dmkzwo\ContaoLayoutBundle\Library;

use Contao\FilesModel;
use Contao\System;
use Symfony\Component\Yaml\Yaml;

class YamlHelper
{
    public static function getOptionsFromFile($fileKey, $section): array
    {
        $configKey = 'layout.' . $fileKey . '.file';

        if (System::getContainer()->hasParameter($configKey)) {
            $definitionFile = TL_ROOT . \DIRECTORY_SEPARATOR . 'config' . \DIRECTORY_SEPARATOR . System::getContainer()->getParameter($configKey);

            if (file_exists($definitionFile)) {
                $values = Yaml::parseFile($definitionFile);

                if (\is_array($values) && \array_key_exists($section, $values) && \count($values[$section])) {
                    return $values[$section];
                }
            }
        }

        return [];
    }

    public static function getValueFromFile($fileKey, $key): string
    {
        $configKey = 'layout.' . $fileKey . '.file';

        if (System::getContainer()->hasParameter($configKey)) {
            $definitionFile = TL_ROOT . \DIRECTORY_SEPARATOR . 'config' . \DIRECTORY_SEPARATOR . System::getContainer()->getParameter($configKey);

            if (file_exists($definitionFile)) {
                $values = Yaml::parseFile($definitionFile);

                if (\is_array($values) && \array_key_exists($key, $values)) {
                    return $values[$key];
                }
            }
        }

        return '';
    }
}
