<?php

declare(strict_types=1);

/*
 * This file is part of dmkzwo/contao-layout-bundle.
 *
 * (c) Dmkzwo GmbH
 *
 * @license proprietary
 */

namespace Dmkzwo\ContaoLayoutBundle\Library;

use Contao\FilesModel;
use Contao\System;

class ArticleHelper
{
    public static function addStylesToTemplate(&$objTemplate): void
    {
        $addStyleClasses = [];

        $baseArticleStyleClass = 'mod_article';

        $addStyleClasses[] = $baseArticleStyleClass.'--paddingtop'.'-'.$objTemplate->dzPaddingtop;
        $addStyleClasses[] = $baseArticleStyleClass.'--paddingbottom'.'-'.$objTemplate->dzPaddingbottom;
        $addStyleClasses[] = $baseArticleStyleClass.'--theme'.'-'.$objTemplate->dzTheme;

        if ($objTemplate->dzOverlap !== 'none') {
            $addStyleClasses[] = $baseArticleStyleClass.'--overlap'.'-'.$objTemplate->dzOverlap;
        }

        if ($objTemplate->dzFullwidth) {
            $addStyleClasses[] = $baseArticleStyleClass . '--full-width';
        }

        if ($objTemplate->dzAddCustomBgColor && preg_match('/^[a-fA-F0-9]{6}$/', $objTemplate->dzCustomBgColor)) {
            $addStyleClasses[] = $baseArticleStyleClass . '--bg-color-custom';
            $objTemplate->style .= ' background-color: #' . $objTemplate->dzCustomBgColor . ' ';
        } else {
            $addStyleClasses[] = $baseArticleStyleClass.'--bgcolor'.'-'.$objTemplate->dzBgColor;
        }

        if ($objTemplate->dzBgSrc) {
            $objModel = FilesModel::findByUuid($objTemplate->dzBgSrc);

            if (null !== $objModel && is_file(System::getContainer()->getParameter('kernel.project_dir').'/'.$objModel->path)) {
                $bgStyle = "url('" . rawurldecode($objModel->path) . "')";

                if ($objTemplate->dzBgDarken) {
                    $darkenValue = self::getDarkenValue();
                    $bgStyle = sprintf("linear-gradient(rgba(0, 0, 0, %s), rgba(0, 0, 0, %s)), ", $darkenValue, $darkenValue) . $bgStyle;

                    $addStyleClasses[] = $baseArticleStyleClass.'--bg-darken';
                }

                $bgStyle = " background-image: " . $bgStyle . ";";

                if ($objTemplate->dzFullwidth) {
                    $objTemplate->styleInside = $objTemplate->styleInside . " " . $bgStyle;
                    $addStyleClasses[] = $baseArticleStyleClass . '--with-bg-image';
                } else {
                    $objTemplate->style .= $objTemplate->style . " " . $bgStyle;
                    $addStyleClasses[] = $baseArticleStyleClass . '--with-bg-image';
                }
            }


        }

        $addStyleClassesStr = implode(' ', $addStyleClasses);

        $objTemplate->class .= ' '.$addStyleClassesStr;
    }

    public static function getDarkenValue(): string
    {
        $value = YamlHelper::getValueFromFile('articlesettings', 'bgdarken');

        if (empty($value)) {
            $value = '0.5';
        }

        return $value;
    }
}
