# Contao Bundle - Layout extension

Diese Erweiterung erlaubt die individuelle/redaktionelle Einstellung von (Innen)abständen, Hintergrundbildern, etc. für Artikel und Content-Elemente.
Dazu werden die im Backend vorgenommenen Einstellungen als CSS-Klassen bzw. Styleangaben zur Frontentausgabe hinzugefügt. Die Interpretation dieser CSS-Klassen ist frei wählbar.

## Installation

Satis-Repository zu composer.json hinzufügen:

```
"repositories": [
{
"type": "composer",
"url": "https://satis.dmkzwo-service.de"
},
...
]
```

Installation per composer:

```
composer require dmkwzo/contao-layout-bundle
```


## Einstellungen für Artikel

### Innenabstand oben (padding)

Auswahl: gemäß Abstandsdefinition (s.u.) \
Style-Klasse: mod_article--paddingtop-*

### Innenabstand unten (padding)

Auswahl: gemäß Abstandsdefinition (s.u.) \
Style-Klasse: mod_article--paddingbottom-*

### volle Breite

Style-Klasse: *mod_article--full-width*

### Hintergrundbild

Style-Klasse: *mod_article--with-bg-image* \
Style-Angabe: *background-image: url('files/path/to/image.jpg');*

### Hintergrundbild abgedunkelt

Style-Klasse: *mod_article--bg-darken* \
Style-Angabe: *background-image: linear-gradient(rgba(0, 0, 0, 0.5), rgba(0, 0, 0, 0.5)), url('files/path/to/image.jpg');*


## Einstellungen für Content-Elemente

### Abstand unten

Auswahl: gemäß Abstandsdefinition (s.u.)

### Keycolor

Auswahl: gemäß Farbdefinition (s.u.) \
Style-Klasse: content-keycolor-*

### Hintergrundfarbe

Auswahl: gemäß Farbdefinition (s.u.) \
Style-Klasse: content-bgcolor-*

### Hintergrundbild

Style-Klasse: *content-with-bgimage* \
Style-Angabe: *background-image: url('files/path/to/image.jpg');*

### Hintergrundbild abgedunkelt

Style-Angabe: *background-image: linear-gradient(rgba(0, 0, 0, 0.5), rgba(0, 0, 0, 0.5)), url('files/path/to/image.jpg');*



## Farbdefinitionen

Die zur Verfügung stehende Auswahl von Key- und Hintergrundfarben für Content-Elemente erfolgt in den folgenden beiden Dateien:

*config/general_keycolors.yml*:

```
keycolors:
  standard: "Standard"
  white: "Weiß"
  yellow: "Gelb"
  red: "Rot"
  ...
```

*config/general_bgcolors.yml*:

```
bgcolors:
  standard: "Standard"
  white: "Weiß"
  yellow: "Gelb"
  red: "Rot"
  ...
```

## Abstandsdefinitionen

### Content-Elemente

Die zur Verfügung stehende Auswahl von (unteren) Abständen für Content-Elemente erfolgt in der Datei \
*config/cemargins.yml*

z.B.
```
cemargins:
  content-margin-none: "Kein Abstand"
  content-margin-small: "kleinerer Abstand"
  content-margin-standard: "Standard"
  content-margin-large: "größerer Abstand"
```

**Wichtig**: Die Klasse *content-margin-standard* muss enthalten sein.

Existiert diese Datei nicht werden die folgenden (etwas unglücklichen) Legacy-Werte verwendet:

| Auswahl | Style-Klasse |
|---|---|
| kein Abstand | content-margin-none |
| Standard | content-margin-standard |
| Medium Abstand | content-margin-small |
| großer Abstand | content-margin-large |


### Artikel

Die zur Verfügung stehende Auswahl von Innenabständen für Artikel erfolgt in der Datei \
*config/articlepaddings.yml*

z.B. \
```
toppaddings:
  none: "Kein Abstand"
  small: "kleinerer Abstand"
  standard: "Standard"
  large: "größerer Abstand"

bottompaddings:
  none: "Kein Abstand"
  small: "kleinerer Abstand"
  standard: "Standard"
  large: "größerer Abstand"
```

**Wichtig**: Die Klasse *standard* muss jeweils enthalten sein.

Existiert diese Datei nicht werden die folgenden (etwas unglücklichen) Legacy-Werte verwendet:

| Auswahl | Style-Klasse |
|---|---|
| kein Abstand | mod_article--paddingtop-none |
| Standard | mod_article--paddingtop-standard |
| Medium Abstand | mod_article--paddingtop-small |
| großer Abstand | mod_article--paddingtop-large |

| Auswahl | Style-Klasse |
|---|---|
| kein Abstand | mod_article--paddingbottom-none |
| Standard | mod_article--paddingbottom-standard |
| Medium Abstand | mod_article--paddingbottom-small |
| großer Abstand | mod_article--paddingbottom-large |



## Template anpassen

* Template *block_searchable.html5* überschreiben
  ```
  cp vendor/contao/core-bundle/src/Resources/contao/templates/block/block_searchable.html5 TEMPLATEDIR/
  ```

* Folgende Anweisung am Kopf von *block_searchable.html5* hinzufügen:
  ```
  <?php
  \Dmkzwo\ContaoLayoutBundle\Library\ContentHelper::addStylesToTemplate($this);
  ?>
  ```


## Einstellungen

Unter *System/Einstellungen/Layout-Einstellungen* festlegen, welche Content-Elemente welche Einstellungmöglichkeiten erhalten sollen.
