<?php

declare(strict_types=1);

/*
 * This file is part of dmkzwo/contao-layout-bundle.
 *
 * (c) Dmkzwo GmbH
 *
 * @license proprietary
 */

namespace Dmkzwo\ContaoLayoutBundle\Library;

use Contao\FilesModel;
use Contao\System;

class ContentHelper
{
    public static function addStylesToTemplate(&$objTemplate): void
    {
        $objTemplate->style .= ' ' . self::getStyle($objTemplate);
        $objTemplate->class .= ' ' . self::getClasses($objTemplate);
    }

    protected static function getStyle($template)
    {
        $addStyle = '';

        if ($template->dzGeneralBgSrc) {
            $objModel = \FilesModel::findByUuid($template->dzGeneralBgSrc);

            if ($objModel !== null && is_file(\System::getContainer()->getParameter('kernel.project_dir') . '/' . $objModel->path)) {
                $addStyle = "url('" . rawurldecode($objModel->path) . "')";

                if ($template->dzBgDarken) {
                    $addStyle = "linear-gradient(rgba(0, 0, 0, 0.5), rgba(0, 0, 0, 0.5)), " . $addStyle;
                }

                $addStyle = " background-image: " . $addStyle . ";";
            }

        }

        return $addStyle;

    }

    protected static function getClasses($template) {
        $addClasses = [];
        $addClasses[] = $template->dzMarginContent;

        if (!empty($template->dzGeneralKeycolor)) {
            $addClasses[] = 'content-keycolor-' . $template->dzGeneralKeycolor;
        }

        if (!empty($template->dzGeneralBgcolor)) {
            $addClasses[] = 'content-bgcolor-' . $template->dzGeneralBgcolor;
        }

        if (!empty($template->dzGeneralBgSrc)) {
            $addClasses[] = 'content-with-bgimage';
        }

        return implode(' ', $addClasses);
    }

}
