<?php

declare(strict_types=1);

/*
 * This file is part of dmkzwo/contao-layout-bundle.
 *
 * (c) Dmkzwo GmbH
 *
 * @license proprietary
 */

namespace Dmkzwo\ContaoLayoutBundle\Library;

use Contao\FilesModel;
use Contao\System;

class ArticleHelper
{
    public static function addStylesToTemplate(&$objTemplate): void
    {
        $addStyleClasses = [];

        $baseArticleStyleClass = 'mod_article';

        $addStyleClasses[] = $baseArticleStyleClass.'--paddingtop'.'-'.$objTemplate->dzPaddingtop;
        $addStyleClasses[] = $baseArticleStyleClass.'--paddingbottom'.'-'.$objTemplate->dzPaddingbottom;

        if ($objTemplate->dzFullwidth) {
            $addStyleClasses[] = $baseArticleStyleClass . '--full-width';
        }

        if ($objTemplate->dzBgSrc) {
            $objModel = FilesModel::findByUuid($objTemplate->dzBgSrc);

            if (null !== $objModel && is_file(System::getContainer()->getParameter('kernel.project_dir').'/'.$objModel->path)) {
                $bgStyle = "url('" . rawurldecode($objModel->path) . "')";

                if ($objTemplate->dzBgDarken) {
                    $bgStyle = "linear-gradient(rgba(0, 0, 0, 0.5), rgba(0, 0, 0, 0.5)), " . $bgStyle;

                    $addStyleClasses[] = $baseArticleStyleClass.'--bg-darken';
                }

                $bgStyle = " background-image: " . $bgStyle . ";";

                if ($objTemplate->dzFullwidth) {
                    $objTemplate->styleInside .= $bgStyle;
                    $addStyleClasses[] = $baseArticleStyleClass . '--with-bg-image';
                } else {
                    $objTemplate->style .= $bgStyle;
                    $addStyleClasses[] = $baseArticleStyleClass . '--with-bg-image';
                }
            }


        }

        $addStyleClassesStr = implode(' ', $addStyleClasses);

        $objTemplate->class .= ' '.$addStyleClassesStr;
    }
}
