<?php

declare(strict_types=1);

/*
 * This file is part of dmkzwo/contao-layout-bundle.
 *
 * (c) Dmkzwo GmbH
 *
 * @license proprietary
 */

namespace Dmkzwo\ContaoLayoutBundle\Classes;

use Contao\Controller;
use Contao\System;

class Settings
{
    public static function getMarginElements(): array
    {
        if (!empty($GLOBALS['TL_CONFIG']['dzMarginElements'])) {
            return unserialize($GLOBALS['TL_CONFIG']['dzMarginElements']);
        }

        return [];
    }

    public static function getKeycolorElements(): array
    {
        if (!empty($GLOBALS['TL_CONFIG']['dzKeycolorElements'])) {
            return unserialize($GLOBALS['TL_CONFIG']['dzKeycolorElements']);
        }

        return [];
    }

    public static function getBgcolorElements(): array
    {
        if (!empty($GLOBALS['TL_CONFIG']['dzBgcolorElements'])) {
            return unserialize($GLOBALS['TL_CONFIG']['dzBgcolorElements']);
        }

        return [];
    }

    public static function getBgsrcElements(): array
    {
        if (!empty($GLOBALS['TL_CONFIG']['dzBgsrcElements'])) {
            return unserialize($GLOBALS['TL_CONFIG']['dzBgsrcElements']);
        }

        return [];
    }

    public static function getAllContentElementTypes(): array
    {
        Controller::loadDataContainer('tl_content');
        System::loadLanguageFile('tl_content');

        $blacklist = [
            '__selector__',
            'default',
        ];

        $allTypeKeys = array_keys($GLOBALS['TL_DCA']['tl_content']['palettes']);
        $types = [];

        foreach ($allTypeKeys as $key) {
            if (\in_array($key, $blacklist, true)) {
                continue;
            }

            if (
                false !== strpos(strtolower($key), 'stop')
            || (false !== strpos(strtolower($key), 'end'))
            ) {
                continue;
            }

            $types[$key] = $GLOBALS['TL_LANG']['CTE'][$key][0].' ['.$key.']';
        }

        if (\array_key_exists('colsetStart', $GLOBALS['TL_LANG']['CTE'])) {
            $types['colsetStart'] = $GLOBALS['TL_LANG']['CTE']['colsetStart'][0].' [colsetStart]';
        }

        return $types;
    }
}
