<?php

declare(strict_types=1);

/*
 * This file is part of dmkzwo/contao-layout-bundle.
 *
 * (c) Dmkzwo GmbH
 *
 * @license proprietary
 */

namespace Dmkzwo\ContaoLayoutBundle\Classes;

use Dmkzwo\ContaoLayoutBundle\Library\YamlHelper;

class ArticleDca
{
    public function getLegacyPaddingtopBackendOptions(): array
    {
        return [
            'none' => 'kein Abstand',
            'standard' => 'Standard',
            'small' => 'Medium Abstand',
            'large' => 'großer Abstand',
        ];
    }

    public function getLegacyPaddingbottomBackendOptions(): array
    {
        return [
            'none' => 'kein Abstand',
            'standard' => 'Standard',
            'small' => 'Medium Abstand',
            'large' => 'großer Abstand',
        ];
    }

    public function getPaddingtopBackendOptions(): array
    {
        $options = YamlHelper::getOptionsFromFile('articlepadding', 'toppaddings');

        if (empty($options)) {
            $options = $this->getLegacyPaddingtopBackendOptions();
        } else {
            // check for default
            if (!array_key_exists('standard', $options)) {
                $options = ['standard' => 'Standard'];
            }
        }

        return $options;
    }

    public function getPaddingbottomBackendOptions(): array
    {
        $options = YamlHelper::getOptionsFromFile('articlepadding', 'bottompaddings');

        if (empty($options)) {
            $options = $this->getLegacyPaddingbottomBackendOptions();
        } else {
            // check for default
            if (!array_key_exists('standard', $options)) {
                $options = ['standard' => 'Standard'];
            }
        }

        return $options;
    }

}
