<?php


namespace Dmkzwo\ContaoFrontendBundle\Classes\Hooks;

use Contao\CoreBundle\ServiceAnnotation\Hook;
use Contao\PageRegular;
use Contao\LayoutModel;
use Contao\PageModel;
use Contao\Filesmodel;

class FaviconHooks
{
    /**
     * @Hook("generatePage")
     */
    public function addTagsToHeader(PageModel $pageModel, LayoutModel $layout, PageRegular $pageRegular): void
    {
        global $objPage;

        $objRootPage = PageModel::findById($pageModel->rootId);

        if ($objRootPage->favicon) {
            $GLOBALS['TL_HEAD'][] = "\n" . '<link rel="icon" href="/favicon.ico" sizes="any">' . "\n";
        }

        if ($objRootPage->dz_favicon_svg) {
            if (null !== ($objFile = FilesModel::findByUuid($objRootPage->dz_favicon_svg))) {
                $GLOBALS['TL_HEAD'][] = sprintf('<link rel="icon" href="/%s" type="image/svg+xml">', $objFile->path) . "\n";
            }
        }

        if ($objRootPage->dz_favicon_appletouch) {
            if (null !== ($objFile = FilesModel::findByUuid($objRootPage->dz_favicon_appletouch))) {
                $GLOBALS['TL_HEAD'][] = sprintf('<link rel="apple-touch-icon" href="/%s">', $objFile->path) . "\n";
            }
        }

        if ($objRootPage->dz_favicon_manifest) {
            if (null !== ($objFile = FilesModel::findByUuid($objRootPage->dz_favicon_manifest))) {
                $GLOBALS['TL_HEAD'][] = sprintf('<link rel="manifest" href="/%s">', $objFile->path) . "\n";
            }
        }

        if ($objRootPage->dz_favicon_misc) {
            $GLOBALS['TL_HEAD'][] = $objRootPage->dz_favicon_misc . "\n";
        }
    }
}
