<?php

namespace Dmkzwo\ContaoEventapiBundle\Module;

use Contao\Config;
use Contao\CoreBundle\Controller\FrontendModule\AbstractFrontendModuleController;
use Contao\CoreBundle\Exception\PageNotFoundException;
use Contao\CoreBundle\Exception\RedirectResponseException;
use Contao\CoreBundle\ServiceAnnotation\FrontendModule;
use Contao\Environment;
use Contao\FilesModel;
use Contao\FrontendTemplate;
use Contao\Input;
use Contao\MemberModel;
use Contao\ModuleModel;
use Contao\PageModel;
use Contao\Pagination;
use Contao\StringUtil;
use Contao\System;
use Contao\Template;
use Contao\UserModel;
use Dmkzwo\ContaoEventapiBundle\Classes\EventApiClient;
use Dmkzwo\ContaoEventapiBundle\Classes\EventCollectionFilters;
use Dmkzwo\ContaoEventapiBundle\Library\TranslationHelper;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * @FrontendModule(EventSearchModuleController::TYPE)
 */
class EventSearchModuleController extends AbstractEventCollectionModuleController
{
    public const TYPE = 'event_search_module';

    protected $baseCssClass = 'mod_eventsearch';


    protected function filterEvents(ModuleModel $model, $client): void
    {
        $calendarIds = unserialize($model->cal_api_calendar);
        $langWebsite = $GLOBALS['TL_LANGUAGE'];

        $client->setCalendars($calendarIds);
        $client->setWebsite($langWebsite);
        $client->onlyFuture();

        $filters = EventCollectionFilters::getFilters();

        if ($filters['sender']['values']) {
            $client->setSenders($filters['sender']['values']);
        }

        if ($filters['targetgroup']['values']) {
            $client->setTargetGroups($filters['targetgroup']['values']);
        }

        if ($filters['state']['values']) {
            $client->setStates($filters['state']['values']);
        }

        if ($filters['format']['values']) {
            $client->setFormats($filters['format']['values']);
        }

        if ($filters['zip']['values']['zip']) {
            $client->setProximity($filters['zip']['values']);
        }

        if ($filters['month']['values']) {
            $client->setMonth($filters['month']['values']);
        }
    }

    /*
    protected function _getResponse(Template $template, ModuleModel $model, Request $request): ?Response
    {
        $calendarIds = unserialize($model->cal_api_calendar);
        $langWebsite = $GLOBALS['TL_LANGUAGE'];

        $client = new EventApiClient();

        $client->setCalendars($calendarIds);
        $client->setWebsite($langWebsite);
        $client->onlyFuture();

        $filters = EventCollectionFilters::getFilters();

        if ($filters['sender']['values']) {
            $client->setSenders($filters['sender']['values']);
        }

        if ($filters['targetgroup']['values']) {
            $client->setTargetGroups($filters['targetgroup']['values']);
        }

        if ($filters['state']['values']) {
            $client->setStates($filters['state']['values']);
        }

        if ($filters['format']['values']) {
            $client->setFormats($filters['format']['values']);
        }

        if ($filters['zip']['values']['zip']) {
            $client->setProximity($filters['zip']['values']);
        }

        if ($filters['month']['values']) {
            $client->setMonth($filters['month']['values']);
        }

        var_dump($client->getUrl());

        $events = $client->getCollection();

//        dd($events);

        $total = \count($events);
        $limit = $total;
        $offset = 0;

        // Overall limit
        if ($model->cal_limit > 0)
        {
            $total = min($model->cal_limit, $total);
            $limit = $total;
        }

        // Pagination
        if ($model->perPage > 0)
        {
            $id = 'page_e' . $model->id;
            $page = Input::get($id) ?? 1;

            // Do not index or cache the page if the page number is outside the range
            if ($page < 1 || $page > max(ceil($total/$model->perPage), 1))
            {
                throw new PageNotFoundException('Page not found: ' . Environment::get('uri'));
            }

            $offset = ($page - 1) * $model->perPage;
            $limit = min($model->perPage + $offset, $total);

            $objPagination = new Pagination($total, $model->perPage, Config::get('maxPaginationLinks'), $id);
            $template->pagination = $objPagination->generate("\n  ");
        }

        $eventCount = 0;
        $headerCount = 0;

        $previewUrl = \Controller::replaceInsertTags('{{link_url::11}}');

        // Parse events
        for ($i=$offset; $i<$limit; $i++)
        {
            $event = $events[$i];
//            dd($event);
//            $event = json_decode(json_encode($events[$i]), true); // convert to array

            $blnIsLastEvent = false;

            $objTemplate = new FrontendTemplate($this->cal_template ?: 'event_list_api');

            $objTemplate->lang = $langWebsite;
            $objTemplate->event = $event;

            $translation = TranslationHelper::getTranslation($event, $langWebsite);
            $objTemplate->translation = $translation;
//            $objTemplate->setData($event);

            $objTemplate->previewHref = str_replace('.html', '', $previewUrl) . '/' . $event['id'] . '.html';

            // Add the template variables
            $objTemplate->classList = ((($headerCount % 2) == 0) ? ' even' : ' odd') . (($headerCount == 0) ? ' first' : '') . ($blnIsLastEvent ? ' last' : '');
            $objTemplate->classUpcoming = ((($eventCount % 2) == 0) ? ' even' : ' odd') . (($eventCount == 0) ? ' first' : '') . ((($offset + $eventCount + 1) >= $limit) ? ' last' : '');
            $objTemplate->readMore = StringUtil::specialchars(sprintf($GLOBALS['TL_LANG']['MSC']['readMore'], $event['name']));
            $objTemplate->more = $GLOBALS['TL_LANG']['MSC']['more'];
            $objTemplate->locationLabel = $GLOBALS['TL_LANG']['MSC']['location'];

            $strEvents .= $objTemplate->parse();

            ++$eventCount;
            ++$headerCount;
        }

        // No events found
        if (!$strEvents)
        {
            $strEvents = "\n" . '<div class="empty">' . $strEmpty . '</div>' . "\n";
        }

        $template->total = $total;
        $template->headline = $this->headline;
        $template->events = $strEvents;
        $template->eventCount = $eventCount;

//        $template->events = $events;

        return $template->getResponse();
    }
*/

}

