<?php

namespace Dmkzwo\ContaoEventapiBundle\Module;

use Contao\CoreBundle\Controller\FrontendModule\AbstractFrontendModuleController;
use Contao\CoreBundle\Exception\RedirectResponseException;
use Contao\CoreBundle\ServiceAnnotation\FrontendModule;
use Contao\FrontendTemplate;
use Contao\Input;
use Contao\MemberModel;
use Contao\ModuleModel;
use Contao\PageModel;
use Contao\System;
use Contao\Template;
use Contao\UserModel;
use Dmkzwo\ContaoEventapiBundle\Classes\EventApiClient;
use Dmkzwo\ContaoEventapiBundle\Classes\FormParser;
use Dmkzwo\ContaoEventapiBundle\Classes\FormValidator;
use Dmkzwo\ContaoEventapiBundle\Classes\ParticipantApiClient;
use Dmkzwo\ContaoEventapiBundle\Classes\RegistrationForm;
use Dmkzwo\ContaoEventapiBundle\Library\TranslationHelper;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * @FrontendModule(EventRegistrationModuleController::TYPE)
 */
class EventRegistrationModuleController extends BaseEventModuleController
{
    public const TYPE = 'event_registration_module';

    protected $template;
    protected $model;

    protected $baseCssClass = 'mod_eventregistration';


    protected function getResponse(Template $template, ModuleModel $model, Request $request): ?Response
    {
        $this->template = $template;
        $this->model = $model;

        $langWebsite = $GLOBALS['TL_LANGUAGE'];

        $eventId = $this->getEventIdFromAlias();

        $eventClient = new EventApiClient();
        $event = $eventClient->getPublishedEventById($eventId);

        // event not found or published
        if (!$event) {
            throw new PageNotFoundException('Event not found: ' . Environment::get('uri'));
        }

        $translation = TranslationHelper::getTranslation($event, $langWebsite);

        $template->event = $event;
        $template->translation = $translation;

        if ($event['soldout'] || $event['paused'] || $event['isExpired']) {
            $template->setName('mod_event_registration_module_disabled');

        } else {
            $this->handleRegistration($template, $event, $translation, $langWebsite, $model);
        }

        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
//            dd($template->fields);
        }

        return $template->getResponse();
    }



    protected function handleOptin($token, $template)
    {
        $template->setName('mod_event_registration_module_optin');

        $participantClient = new ParticipantApiClient();

        $participant = $participantClient->getParticipantByHash($token);

        if (!$participant) {
            $template->activationStatus = 'INVALID';

        } elseif (array_key_exists('confirmed', $participant) && $participant['confirmed']) {
            $template->activationStatus = 'CONFIRMED';

        } else {
            $participantClient->confirmParticipant($participant['id']);
        }


//        dd($participant);
//
//        if ($response->getStatusCode() !== 200) {
//            // handle error / TODO
//            dump('server error');
//            dd($response->getInfo('debug'));
//        }

        return $template->getResponse();
    }

    protected function handleRegistration(Template &$template, $event, $translation, $langWebsite, ModuleModel $model): void
    {
        $tk = \Input::get('tk');

        if (strlen(trim($tk))) {
            $this->handleOptin($tk, $template);
        }

        $form = new RegistrationForm();
        $form->setEvent($event);
        $form->setTranslation($translation);

        $form->generate();

        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $form->setValuesFromPost();
            $form->validate();

            if ($form->isValid()) {
//                dd('valid');

                $participantClient = new ParticipantApiClient();
                $statusCode = $participantClient->createParticipant($event, $langWebsite, $form->getValues());

//                dd($form->getValues());

                if ($statusCode == 201) {
                    \Controller::redirect(\Controller::replaceInsertTags('{{link_url::' . $model->dzOnlineRegistrationSuccessPage . '}}'));
                }

                $template->statusCode = $statusCode;
                dd($statusCode);

//                if ($response->getStatusCode() !== 201) {
                if ($statusCode !== 201) {
                    // handle error / TODO
//                    dump('server error');
//                    dd($response);
//                    dd($response->getInfo('debug'));
                }

                // redirect to success page / TODO

//                dd('participant created successfully');

            }
        }

        $template->layout = $form->getLayout();
        $template->fields = $form->getFields();
    }
}

