<?php

namespace Dmkzwo\ContaoEventapiBundle\Module;

use Contao\CoreBundle\Controller\FrontendModule\AbstractFrontendModuleController;
use Contao\CoreBundle\Exception\RedirectResponseException;
use Contao\CoreBundle\ServiceAnnotation\FrontendModule;
use Contao\FrontendTemplate;
use Contao\Input;
use Contao\MemberModel;
use Contao\ModuleModel;
use Contao\PageModel;
use Contao\System;
use Contao\Template;
use Contao\UserModel;
use Contao\Environment;
use Dmkzwo\ContaoEventapiBundle\Classes\EventApiClient;
use Dmkzwo\ContaoEventapiBundle\Classes\EventOutputDetail;
use Dmkzwo\ContaoEventapiBundle\Classes\FormParser;
use Dmkzwo\ContaoEventapiBundle\Interfaces\EventReaderInterface;
use Dmkzwo\ContaoEventapiBundle\Library\TranslationHelper;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Contao\CoreBundle\Exception\PageNotFoundException;

/**
 * @FrontendModule(EventReaderModuleController::TYPE)
 */
class EventReaderModuleController extends BaseEventReaderModuleController
{
    public const TYPE = 'event_reader_module';

    protected $baseCssClass = 'mod_eventreader';



    public function getEventIdFromUrl()
    {
        return $this->getEventIdFromAlias();
    }

    public function getEvent($eventId)
    {
        $client = new EventApiClient();

//        $client->setDebug(true);

        $publishedEvent = $client->getPublishedEventById($eventId);

//        dd($publishedEvent);

        return $publishedEvent;
    }

    public function getLang()
    {
        return $GLOBALS['TL_LANGUAGE'];
    }
}

