<?php

namespace Dmkzwo\ContaoEventapiBundle\Module;

use Contao\CoreBundle\Controller\FrontendModule\AbstractFrontendModuleController;
use Contao\CoreBundle\Exception\RedirectResponseException;
use Contao\CoreBundle\ServiceAnnotation\FrontendModule;
use Contao\FrontendTemplate;
use Contao\Input;
use Contao\MemberModel;
use Contao\ModuleModel;
use Contao\PageModel;
use Contao\System;
use Contao\Template;
use Contao\UserModel;
use Contao\Environment;
use Dmkzwo\ContaoEventapiBundle\Classes\EventApiClient;
use Dmkzwo\ContaoEventapiBundle\Classes\EventOutputDetail;
use Dmkzwo\ContaoEventapiBundle\Classes\FormParser;
use Dmkzwo\ContaoEventapiBundle\Interfaces\EventReaderInterface;
use Dmkzwo\ContaoEventapiBundle\Library\TranslationHelper;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Contao\CoreBundle\Exception\PageNotFoundException;

/**
 * @FrontendModule(EventReaderModuleController::TYPE)
 */
class EventPreviewReaderModuleController extends BaseEventReaderModuleController
{
    public const TYPE = 'event_preview_reader_module';

    protected $baseCssClass = 'mod_eventreader';

    protected $showPublishedOnly = false;

    public function getEventIdFromUrl()
    {
        return \Input::get('auto_item');
    }

    public function getEvent($eventId)
    {
        $client = new EventApiClient();

        return $client->getEventById($eventId);
    }

    public function getLang()
    {
        return \Input::get('lang');
    }
}

