<?php

namespace Dmkzwo\ContaoEventapiBundle\Module;

use Contao\CoreBundle\Controller\FrontendModule\AbstractFrontendModuleController;
use Contao\CoreBundle\Exception\RedirectResponseException;
use Contao\CoreBundle\ServiceAnnotation\FrontendModule;
use Contao\FrontendTemplate;
use Contao\Input;
use Contao\MemberModel;
use Contao\ModuleModel;
use Contao\PageModel;
use Contao\System;
use Contao\Template;
use Contao\UserModel;
use Contao\Environment;
use Dmkzwo\ContaoEventapiBundle\Classes\EventOutputHelper;
use Dmkzwo\ContaoEventapiBundle\Library\OutputHelper;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\Exception\NotFoundHttpException;
use Contao\CoreBundle\Exception\PageNotFoundException;

use Dmkzwo\ContaoEventapiBundle\Classes\EventOutputDetail;
use Dmkzwo\ContaoEventapiBundle\Interfaces\EventReaderInterface;
use Dmkzwo\ContaoEventapiBundle\Library\TranslationHelper;

abstract class BaseEventReaderModuleController extends BaseEventModuleController implements EventReaderInterface
{
    protected $baseCssClass;

    protected $showPublishedOnly = true;

    protected function getResponse(Template $template, ModuleModel $model, Request $request): ?Response
    {
        $this->initTemplate($template);

        $langWebsite = $this->getLang();

        $eventId = $this->getEventIdFromUrl();

//        $client = new EventApiClient();

//        $event = EventApiClient::getEventByAlias($alias);
//        $event = $client->getPublishedEventById($eventId);

        $event = $this->getEvent($eventId);

//        dd($event);

        if (!$event) {
            throw new PageNotFoundException('Event not found: ' . Environment::get('uri'));
        }


        $translation = TranslationHelper::getTranslation($event, $langWebsite, $this->showPublishedOnly);
        // TODO: continue with preview version (get parameter)

        $this->enrichEvent($event, $translation);

//        $eventDetailOutput = new EventOutputDetail();
//
//        $template->event = $event;
//        $template->translation = $translation;
//
//        $template->detail = $eventDetailOutput->parse($translation['detailData']);

        $template->event = $event;
        $template->translation = $translation;

        $template->baseCssClass = $this->baseCssClass;

//        $template->regLink = sprintf('%s/%s/%s.html', $langWebsite, \System::getContainer()->getParameter('eventapi.regalias'), $translation['url']);
        $template->regLink = $event['detailPages']['REGISTRATION'][$langWebsite];

        return $template->getResponse();
    }

    protected function enrichEvent(&$event, $translation) {
        $event['statesArr'] = OutputHelper::RelatedDataToArr($event['states']);
        $event['targetGroupArr'] = OutputHelper::RelatedDataToArr($event['targetGroup']);

        $eventDetailOutput = new EventOutputDetail();



        $event['detailHtml'] = $eventDetailOutput->parse($translation['detailData']);
//        dd($translation['contactXml']);
        $event['contactHtml'] = EventOutputHelper::generateContactHtml($translation['contactXml']);
        $event['linkHtml'] = EventOutputHelper::generateLinkHtml($translation['linkXml']);
        $event['refHtml'] = EventOutputHelper::generateRefHtml($translation['refXml']);
    }
}
