<?php

namespace Dmkzwo\ContaoEventapiBundle\Module;

use Contao\CoreBundle\Controller\FrontendModule\AbstractFrontendModuleController;
use Contao\CoreBundle\Exception\RedirectResponseException;
use Contao\CoreBundle\ServiceAnnotation\FrontendModule;
use Contao\FrontendTemplate;
use Contao\Input;
use Contao\MemberModel;
use Contao\ModuleModel;
use Contao\PageModel;
use Contao\System;
use Contao\Template;
use Contao\UserModel;
use Dmkzwo\ContaoEventapiBundle\Classes\EventApiClient;
use Dmkzwo\ContaoEventapiBundle\Classes\FormParser;
use Dmkzwo\ContaoEventapiBundle\Classes\SenderApiClient;
use Dmkzwo\ContaoEventapiBundle\Library\TranslationHelper;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * @FrontendModule(BaseEventModuleController::TYPE)
 */
abstract class BaseEventModuleController extends AbstractFrontendModuleController
{
    protected $senders;

    protected function getEventIdFromAlias(): int
    {
        $alias = \Input::get('auto_item');

        if (!preg_match('/^([0-9]+)--.*/', $alias, $matches)) {
            dd('invalid event url'); // TODO
        }

        return intval($matches[1]);

    }

    protected function initTemplate(&$template)
    {
        $senderClient = new SenderApiClient();

        $template->senders = $senderClient->getLutAll();
    }
}

