<?php

namespace Dmkzwo\ContaoEventapiBundle\Module;

use Contao\Config;
use Contao\CoreBundle\Controller\FrontendModule\AbstractFrontendModuleController;
use Contao\CoreBundle\Exception\PageNotFoundException;
use Contao\CoreBundle\Exception\RedirectResponseException;
use Contao\CoreBundle\ServiceAnnotation\FrontendModule;
use Contao\Environment;
use Contao\FilesModel;
use Contao\FrontendTemplate;
use Contao\Input;
use Contao\MemberModel;
use Contao\ModuleModel;
use Contao\PageModel;
use Contao\Pagination;
use Contao\StringUtil;
use Contao\System;
use Contao\Template;
use Contao\UserModel;
use Dmkzwo\ContaoEventapiBundle\Classes\EventApiClient;
use Dmkzwo\ContaoEventapiBundle\Library\TranslationHelper;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * @FrontendModule(AbstractEventCollectionModuleController::TYPE)
 */
abstract class AbstractEventCollectionModuleController extends AbstractFrontendModuleController
{

    abstract protected function filterEvents(ModuleModel $model, EventApiClient $client): void;

    protected function getResponse(Template $template, ModuleModel $model, Request $request): ?Response
    {
        $this->template = $template;
        $this->model = $model;

        $calendarIds = unserialize($model->cal_api_calendar);

        $langWebsite = $GLOBALS['TL_LANGUAGE'];
//        $langWebsite = 'en';

        $client = new EventApiClient();

        $this->filterEvents($model, $client);

//        $client->setCalendars($calendarIds);
//        $client->setWebsite($langWebsite);
//        $client->onlyFuture();



//        dd($events);

//        $events = EventApiClient::getFutureEventsByCalendarsAndWebsite($calendarIds, $GLOBALS['TL_LANGUAGE']);

//        dd($events);

        if ($model->perPage > 0)
        {
            $id = 'page_e' . $model->id;
            $page = Input::get($id) ?? 1;

            $client->setPage($page);
            $client->setItemsPerPage($model->perPage);
        }

        $startTs = microtime();
        $events = $client->getCollection();
        $total = $client->getTotal();
        $requestedEvents = sizeof($events);
        $endTs = microtime();

        if ($model->perPage > 0) {
            $id = 'page_e' . $model->id;
            $objPagination = new Pagination($total, $model->perPage, Config::get('maxPaginationLinks'), $id);
            $template->pagination = $objPagination->generate("\n  ");
        }

//        dump($client->getUrl());
//
//        dd($events);

        $template->duration = $endTs - $startTs;

        /*
        $total = \count($events);
        $limit = $total;
        $offset = 0;

        // Overall limit
        if ($model->cal_limit > 0)
        {
            $total = min($model->cal_limit, $total);
            $limit = $total;
        }

        // Pagination
        if ($model->perPage > 0)
        {
            $id = 'page_e' . $model->id;
            $page = Input::get($id) ?? 1;

            // Do not index or cache the page if the page number is outside the range
            if ($page < 1 || $page > max(ceil($total/$model->perPage), 1))
            {
                throw new PageNotFoundException('Page not found: ' . Environment::get('uri'));
            }

            $offset = ($page - 1) * $model->perPage;
            $limit = min($model->perPage + $offset, $total);

            $objPagination = new Pagination($total, $model->perPage, Config::get('maxPaginationLinks'), $id);
            $template->pagination = $objPagination->generate("\n  ");
        }
        */

        $eventCount = 0;
        $headerCount = 0;

        $previewUrl = \Controller::replaceInsertTags('{{link_url::11}}');

        // Parse events
        foreach ($events as $event)
//        for ($i=$offset; $i<$limit; $i++)
        {
//            $event = $events[$i];
//            dd($event);
//            $event = json_decode(json_encode($events[$i]), true); // convert to array

            $blnIsLastEvent = false;

            $objTemplate = new FrontendTemplate($this->cal_template ?: 'event_list_api');

            $objTemplate->lang = $langWebsite;
            $objTemplate->event = $event;

            $translation = TranslationHelper::getTranslation($event, $langWebsite);
            $objTemplate->translation = $translation;
//            $objTemplate->setData($event);

            $objTemplate->previewHref = str_replace('.html', '', $previewUrl) . '/' . $event['id'] . '.html';

            // Add the template variables
            $objTemplate->classList = ((($headerCount % 2) == 0) ? ' even' : ' odd') . (($headerCount == 0) ? ' first' : '') . ($blnIsLastEvent ? ' last' : '');
            $objTemplate->classUpcoming = ((($eventCount % 2) == 0) ? ' even' : ' odd') . (($eventCount == 0) ? ' first' : '') . ((($offset + $eventCount + 1) >= $limit) ? ' last' : '');
            $objTemplate->readMore = StringUtil::specialchars(sprintf($GLOBALS['TL_LANG']['MSC']['readMore'], $event['name']));
            $objTemplate->more = $GLOBALS['TL_LANG']['MSC']['more'];
            $objTemplate->locationLabel = $GLOBALS['TL_LANG']['MSC']['location'];

            $strEvents .= $objTemplate->parse();

            ++$eventCount;
            ++$headerCount;
        }

        // No events found
        if (!$strEvents)
        {
            $strEvents = "\n" . '<div class="empty">' . $strEmpty . '</div>' . "\n";
        }

        $template->total = $total;
        $template->requested = $requestedEvents;
        $template->headline = $this->headline;
        $template->events = $strEvents;
        $template->eventCount = $eventCount;

//        $template->events = $events;

        return $template->getResponse();
    }


}

