<?php


namespace Dmkzwo\ContaoEventapiBundle\Library;


class TranslationHelper
{

    public static function getTranslation($event, $lang, $showPublishedOnly = false) {
        $translation = [];

        if (empty($lang)) {
            return $event;
        }

//        dd($event['availableTranslationLanguages']);

        if (!$event['availableTranslationLanguages']) {
            return $event;
        }

        if (in_array($lang, $event['availableTranslationLanguages'])) {
            if ($showPublishedOnly && !$event['availableTranslations'][$lang]['published']) {
                $translation = $event;
            } else {
                $translation = $event['availableTranslations'][$lang];
                $translation['isTranslation'] = true;
            }
        } else {
            if (array_key_exists('fallbackLang', $event) && in_array($event['fallbackLang'], $event['availableTranslationLanguages'])) {
                if ($showPublishedOnly && !$event['availableTranslations'][$event['fallbackLang']]['published']) {
                    $translation = $event;
                } else {
                    $translation = $event['availableTranslations'][$event['fallbackLang']];
                    $translation['isTranslation'] = true;
                }
            } else {
                $translation = $event;
            }
        }
//        dd($translation);

        return $translation;
    }

    public static function getEventTranslationByLang($event, $lang)
    {
        foreach ($event['translations'] as $translation) {
            if ($lang == $translation['lang']) {
                return $translation;
            }
        }

        return [];
    }

}
