<?php

namespace Dmkzwo\ContaoEventapiBundle\Classes;

class RegistrationForm
{
    protected $event;
    protected $translation;

    protected $xml;

    protected $layout = [];
    protected $fields = [];

    protected $values = [];
    protected $errors = [];

    public function getFields() {
        return $this->fields;
    }

    public function getLayout() {
        return $this->layout;
    }

    public function getValues() {
        return $this->values;
    }

    public function setEvent($event): void {
        $this->event = $event;
    }

    public function setTranslation($translation): void
    {
        $this->translation = $translation;
    }

//    public function setXml($xml) {
//        $formParser = new FormParser();
//
//        $formParser->setFormXml($xml);
//        $formParser->generate();
//
//        $this->layout = $formParser->getFields();
//
////        dd($this->layout);
//
//        foreach ($formParser->getFieldsOnly() as $field) {
//            $this->fields[$field['name']] = $field;
//        }
//    }
//
//    public function addTranslationXml($xml) {
//        $translation = $this->xmlToArray($xml);
//        dd($translation);
//    }

    public function generate()
    {
        $formXml = $this->event['formFields'];

        $formParser = new FormParser();

        $formParser->setFormXml($formXml);
//        dd($this->event);
        $formParser->setFieldControlXml($this->event['fieldControlXml']);

//        $translationXml
//        $form->setXml($event['formFields']);

        if (array_key_exists('isTranslation', $this->translation)) {
            $formParser->setTranslationXml($this->translation['formTranslation']);
//            $form->addTranslationXml($translation['formTranslation']);
        }

        $formParser->generate();

        $this->layout = $formParser->getFields();

        foreach ($formParser->getFieldsOnly() as $field) {
            $this->fields[$field['name']] = $field;
        }
    }

    protected function xmlToArray($xml)
    {
        return json_decode(json_encode(simplexml_load_string($xml)), true);
    }

    public function setValuesFromPost() {
        foreach ($this->fields as $fieldName => &$field) {
            $field['value'] = $_POST[$fieldName] ?? '';
            $this->values[$fieldName] = $field['value'];
        }
//        $this->values = $values;
    }

    public function isValid() {
        return (bool)!sizeof($this->errors);
    }

    public function validate()
    {
//        $values = $this->values;
//
//        dd($values);

        if (sizeof($this->fields)) {
            foreach ($this->fields as $fieldName => $field) {
                if ($field['type'] == 'meta') {
                    continue;
                }

//                $fieldName = $field['name'];

                if ($field['mandatory']) {
                    if (
                        (($field['type'] == 'text') && !strlen(trim($field['value']))) ||
                        (($field['type'] == 'textarea') && !strlen(trim($field['value']))) ||
                        (($field['type'] == 'checkbox') && ($field['value'] !== '1')) ||
                        (($field['type'] == 'checkbox-multiple') && (!is_array($field['value']))) ||
                        (($field['type'] == 'select') && ($field['value'] == '-1')) ||
                        (($field['type'] == 'radio') && (!strlen($field['value']))) ||
                        (($field['type'] == 'date') && (!$this->isDateValid($field['value']))
                        )
                    ) {

                        $this->fields[$fieldName]['error'] = true;
                        $this->errors[] = $fieldName;
                    }
                } else {
                    if (
                        (($field['type'] == 'date') && strlen($field['value']) && (!$this->isDateValid($field['value']))
                        )
                    ) {
                        $this->fields[$fieldName]['error'] = true;
                        $this->errors[] = $fieldName;
                    }
                }

            }

        }

    }



    protected function isDateValid($dateStr)
    {
        $isValid = preg_match(
                '/^[0-9]{2}.[0-9]{2}.[0-9]{4}$/',
                $dateStr
            ) && $this->validateDate($dateStr);

        return $isValid;
    }

    protected function validateDate($date, $format = 'd.m.Y')
    {
        $d = \DateTime::createFromFormat($format, $date);
        // The Y ( 4 digits year ) returns TRUE for any integer with any number of digits so changing the comparison from == to === fixes the issue.
        return $d && $d->format($format) === $date;
    }

}
