<?php

namespace Dmkzwo\ContaoEventapiBundle\Classes;

use Symfony\Contracts\HttpClient\ResponseInterface;

class ParticipantApiClient extends BaseApiClient
{
    protected $baseEndpoint = 'participants';

    public function createParticipant($event, $formLang, $data): int
    {
        $postParams = [
            'event' => '/api/events/' . $event['id'],
            'formLang' => $formLang,
            'firstname' => $data['firstname'],
            'lastname' => $data['lastname'],
            'regEmail' => $data['reg_email'],
            'salutation' => $data['salutation'],
            'data' => serialize($data),
        ];

        $this->addParams($postParams);

//        return $this->post('participants', $postParams, true);


        $response = $this->post();

        return $response->getStatusCode();

//        $statusCode = $response->getStatusCode();
////        dump($statusCode);
////        dd($response->toArray(false));
//
//        if ($statusCode != 201) {
//            $data = $response->toArray(false);
//
//            $statusCode = $data['code'];
//        }
//
//        return $statusCode;

//        dump($response->toArray(false));
//        dd($statusCode);

//        try {
//            $response = $this->post('participants', $postParams, true);
//
//            return $response->toArray();
//
//        } catch (\Exception $e) {
//            dump($e);
//            return $response;
//        }

        // TODO: continue...
    }

    public function getParticipantByHash($hash)
    {
        $this->addParam('hash', $hash);

        return $this->getFirstFromCollection();
    }

    public function _getParticipantByHash($hash)
    {
        $getParams = [
            'hash' => $hash,
        ];

        $participants = $this->get('participants', $getParams, false)->toArray();

        if (is_array($participants) && sizeof($participants)) {
            return $participants[0];
        }

        return false;

    }

    public function confirmParticipant($participantId): ResponseInterface
    {
        $this->addParam('confirmed', true);

        return $this->patch($participantId);

    }

//    public static function createParticipantStatic($event, $formLang, $data)
//    {
////        dd($data);
//
//        $postParams = [
//            'event' => '/api/events/' . $event->id,
//            'formLang' => $formLang,
//            'firstname' => $data['firstname'],
//            'lastname' => $data['lastname'],
//            'data' => serialize($data),
//        ];
//
////        dd($postParams['data']);
//
//        return self::runPostRequest('participants', $postParams, false);
//
//
//    }


}
