<?php

namespace Dmkzwo\ContaoEventapiBundle\Classes;

class FormParser
{
    protected $formXml;
    protected $translationXml;
    protected $translationLut = [];
    protected $fieldControlXml;
    protected $fieldControlLut = [];

    protected $actRow = null;
    protected $actLeft = null;
    protected $actRight = null;
    protected $actSingle = null;
    protected $actAddField = [];
    protected $actOptions = [];
    protected $actContent = [];
    protected $actNode = [];
    protected $isContent = false;

    protected $fields = [];
    protected $fieldsOnly = [];

    public function setFormXml($xml)
    {
        $this->formXml = $xml;
//        dump($xml);
    }

    public function setTranslationXml(string $translationXml): void
    {
        $this->translationXml = $translationXml;

        if ($this->translationXml) {
            $this->parseTranslationXml();
        }
    }


    public function setFieldControlXml($fieldControlXml): void
    {
        $this->fieldControlXml = $fieldControlXml;

        if ($this->fieldControlXml) {
            $this->parseFieldControlXml();
        }

//        dd($this->fieldControlLut);
    }

    protected function hasTranslation(): bool
    {
        return sizeof($this->translationLut);
    }

    protected function useField($fieldName): bool
    {
        $langWebsite = $GLOBALS['TL_LANGUAGE'];

        if (!array_key_exists($fieldName, $this->fieldControlLut)) {
            return true;
        }

        $field = $this->fieldControlLut[$fieldName];

        if (array_key_exists('exclude', $field)) {
            $excludes = explode(',', $field['exclude']);

            if (!in_array($langWebsite, $excludes)) {
                return true;
            }
        }

        if (array_key_exists('include', $field)) {
            $includes = explode(',', $field['include']);

            if (in_array($langWebsite, $includes)) {
                return true;
            }
        }

        return false;
    }

    public function getFields()
    {
        return $this->fields;
    }

    public function getFieldsOnly()
    {
        return $this->fieldsOnly;
    }

    public function generate()
    {
        $this->parseFormXml();

//        dd($this->getFields());
    }

    protected function parseTranslationXml()
    {
        $translationArr = $this->xmlToArray($this->translationXml);

        foreach ($translationArr['translation'] as $translationEntry) {
            $this->translationLut[$translationEntry['name']] = $translationEntry;
        }
    }

    protected function parseFieldControlXml()
    {
        $fieldControlArr = $this->xmlToArray($this->fieldControlXml);
//        dd($fieldControlArr);

        foreach ($fieldControlArr['field'] as $field) {
//            dd($field['name']);
            $this->fieldControlLut[$field['name']] = $field;
        }
    }

    protected function translate(&$field)
    {
        $fieldName = $field['name'];
//        dump($fieldName);
//        dd($this->translationLut);

        if (array_key_exists($fieldName, $this->translationLut)) {
            $translatedField = $this->translationLut[$fieldName];

            if (array_key_exists('label', $translatedField)) {
                $field['label'] = $translatedField['label'];
            }

            if (array_key_exists('pretext', $translatedField)) {
                $field['pretext'] = $translatedField['pretext'];
            }

            if (array_key_exists('posttext', $translatedField)) {
                $field['posttext'] = $translatedField['posttext'];
            }

            if (array_key_exists('errormsg', $translatedField)) {
                $field['errormsg'] = $translatedField['errormsg'];
            }

            if (array_key_exists('options', $translatedField)) {
                $field['options'] = $translatedField['options']['option'];
            }

        }
    }

    protected function xmlToArray($xml)
    {
        return json_decode(json_encode(simplexml_load_string($xml)), true);
    }

    protected function parseFormXml()
    {
        if (!strlen($this->formXml)) {
            return array();
        }

        $xml_parser = xml_parser_create();
        // use case-folding so we are sure to find the tag in $map_array
        //xml_parser_set_option($xml_parser, XML_OPTION_CASE_FOLDING, true);
        xml_set_element_handler($xml_parser, array($this, "startElement"), array($this, "endElement"));
        xml_set_character_data_handler($xml_parser, array($this, "characterData"));

        if (!xml_parse($xml_parser, $this->formXml)) {
            die(sprintf("XML error: %s at line %d",
                xml_error_string(xml_get_error_code($xml_parser)),
                xml_get_current_line_number($xml_parser)));
        }

        xml_parser_free($xml_parser);

//        dump($this->formXml);
//        dump($this->fields);

        //echo '<pre>';
        //var_dump($this->additionalFields);
        //echo '</pre>';
        //die();

    }


    private function startElement($parser, $name, $attrs)
    {
        //echo 'start'.$name.'<br />';
        if ($name == 'ROW') {
            $this->actRow = array();
//            $this->actRow['layout'] = 'row';

        } elseif ($name == 'COLUMNS') {
//            $this->actRow = array();
            $this->actRow['layout'] = 'row';

        } elseif ($name == 'SINGLE') {
//            $this->actRow = array();
            $this->actSingle = array();
            $this->actRow['layout'] = 'single';

        } elseif ($name == 'LEFT') {
            $this->actLeft = array();
            //$this->actLeft['col'] = 'left';

        } elseif ($name == 'RIGHT') {
            $this->actRight = array();
            //$this->actRight['col'] = 'right';

        } elseif ($name == 'ADDFIELD') {
            $this->actAddField = array();

        } elseif ($name == 'OPTIONS') {
            $this->actOptions = array();

            //} elseif ($name == 'OPTION') {
            //  $this->actOption = array();

        } else {
            $this->actContent = '';
            $this->actNode = $name;

        }

        $this->isContent = false;
    }


    private function endElement($parser, $name)
    {
        if ($name == 'ROW') {
            if (true || $this->actRow) {
                $this->fields[] = $this->actRow;
                $this->actRow = null;
            }

        } elseif ($name == 'LEFT') {
            if (true || $this->actLeft) {
                $this->actRow['left'] = $this->actLeft;
                $this->actLeft = null;
            }

        } elseif ($name == 'RIGHT') {
            if (true || $this->actRight) {
                $this->actRow['right'] = $this->actRight;
                $this->actRight = null;
            }

//        } elseif ($name == 'COLUMNS') {
//            $this->actRow = array_merge($this->actRow, $this->actSingle);
//            $this->actSingle = null;

        } elseif ($name == 'SINGLE') {
            if ($this->useField($this->actAddField['name'])) {
                $this->actRow = array_merge($this->actRow, $this->actSingle);
                $this->actSingle = null;
            } else {
                $this->actRow = null;
                $this->actSingle = null;
            }

        } elseif ($name == 'ADDFIELD') {
//            dump($this->actAddField['name']);
            if ($this->useField($this->actAddField['name'])) {
//                dump('use');
                if ($this->hasTranslation()) {
                    $this->translate($this->actAddField);
                }

                $this->fieldsOnly[] = $this->actAddField;
                if (is_array($this->actRow)) {
                    if (is_array($this->actLeft)) {
//                    dump('left');
                        $this->actLeft[] = $this->actAddField;
                    } elseif (is_array($this->actRight)) {
//                    dump('right');

                        $this->actRight[] = $this->actAddField;
                    } elseif (is_array($this->actSingle)) {
//                    dump('single');
                        $this->actSingle = $this->actAddField;
                    } else {
//                    dump('unknown');
                        // this should not happen
                    }
                } else {
//                $this->actAddField['layout'] = 'single';
                    $this->fields[] = $this->actAddField;
                }
            }
        } elseif ($name == 'META') {
            if (is_array($this->actSingle)) {
                $this->actSingle = $this->actAddField;
                $this->actSingle['meta'] = '1';

            }
        } elseif ($name == 'OPTIONS') {
            $this->actAddField['options'] = $this->actOptions;

            //} elseif ($name == 'OPTION') {
            //  $this->actAddField['options']['option'] = $this->actOption);


        } elseif (($name != 'ADDFIELD') && ($name != 'OPTIONS')) {
            if ($name == 'OPTION') {
                $this->actOptions[] = $this->actContent;
            } else {
                $this->actAddField[strtolower($name)] = $this->actContent;
            }

        } else {
            //echo "###START###".$name.' '.$this->actContent . "<br /><br />";
            $this->actContent = preg_replace('/\s+/', ' ', $this->actContent);
            $this->actContent = ((trim($this->actContent) == 'NULL') || (trim($this->actContent) == '')) ? '' : $this->actContent;
            //array_push($this->actCategory[$this->actNode], $this->actContent);
        }

        $this->isContent = false;
    }


    private function startElementOld($parser, $name, $attrs)
    {
        //echo 'start'.$name.'<br />';
        if ($name == 'ROW') {
            $this->actRow = array();
            $this->actRow['layout'] = 'row';

        } elseif ($name == 'LEFT') {
            $this->actLeft = array();
            //$this->actLeft['col'] = 'left';

        } elseif ($name == 'RIGHT') {
            $this->actRight = array();
            //$this->actRight['col'] = 'right';

        } elseif ($name == 'ADDFIELD') {
            $this->actAddField = array();

        } elseif ($name == 'OPTIONS') {
            $this->actOptions = array();

            //} elseif ($name == 'OPTION') {
            //  $this->actOption = array();

        } else {
            $this->actContent = '';
            $this->actNode = $name;

        }

        $this->isContent = false;
    }


    private function endElementOld($parser, $name)
    {
        if ($name == 'ROW') {
            $this->fields[] = $this->actRow;
            $this->actRow = null;

        } elseif ($name == 'LEFT') {
            $this->actRow['left'] = $this->actLeft;
            $this->actLeft = null;

        } elseif ($name == 'RIGHT') {
            $this->actRow['right'] = $this->actRight;
            $this->actRight = null;

        } elseif ($name == 'ADDFIELD') {
//            dump($this->actAddField);

            if ($this->hasTranslation()) {
                $this->translate($this->actAddField);
            }

//            dump($this->actAddField);

            $this->fieldsOnly[] = $this->actAddField;

//            dump($this->actRow);
            if (is_array($this->actRow)) {
//                dump('row');
                if (is_array($this->actLeft)) {
                    $this->actLeft[] = $this->actAddField;
                } elseif (is_array($this->actRight)) {
                    $this->actRight[] = $this->actAddField;
                } else {
                    // this should not happen
                }
            } else {
//                dump('single');
                $this->actAddField['layout'] = 'single';
                $this->fields[] = $this->actAddField;
            }

        } elseif ($name == 'OPTIONS') {
            $this->actAddField['options'] = $this->actOptions;

            //} elseif ($name == 'OPTION') {
            //  $this->actAddField['options']['option'] = $this->actOption);


        } elseif (($name != 'ADDFIELD') && ($name != 'OPTIONS')) {
            if ($name == 'OPTION') {
                $this->actOptions[] = $this->actContent;
            } else {
                $this->actAddField[strtolower($name)] = $this->actContent;
            }

        } else {
            //echo "###START###".$name.' '.$this->actContent . "<br /><br />";
            $this->actContent = preg_replace('/\s+/', ' ', $this->actContent);
            $this->actContent = ((trim($this->actContent) == 'NULL') || (trim($this->actContent) == '')) ? '' : $this->actContent;
            //array_push($this->actCategory[$this->actNode], $this->actContent);
        }

        $this->isContent = false;
    }


    private function characterData($parser, $data)
    {
        if (strlen(trim($data)) != 0) {
            if (!$this->isContent) {
                $this->actContent = $data;
            } else {
                $this->actContent .= $data;
            }
        }
        $this->isContent = true;
        //array_push($this->actCategory[$this->actNode], $data);
    }


}
