<?php

namespace Dmkzwo\ContaoEventapiBundle\Classes;

class EventOutputHelper
{
    public static function generateContactHtml($xmlData): string
    {
            return self::generateHtmlFromXml($xmlData, 'event_contact');
    }
    public static function generateLinkHtml($xmlData): string
    {
        return self::generateHtmlFromXml($xmlData, 'event_link');
    }

    public static function generateRefHtml($xmlData): string
    {
        return self::generateHtmlFromXml($xmlData, 'event_ref');
    }


    protected static function generateHtmlFromXml($xmlData, $templateName): string
    {
        if (empty($xmlData)) {
            return '';
        }

        $elements = new \SimpleXMLElement($xmlData);
//dd($elements);

        $template = new \FrontendTemplate($templateName);

        $template->elements = $elements;

        return $template->parse();
    }
}
