<?php

namespace Dmkzwo\ContaoEventapiBundle\Classes;

class EventOutputDetail
{
    protected $xmlIterator;
    protected $level = 0;
    protected $wrappers = array();

    protected $output;

    protected $actOutput;

    protected $actParts;

    protected $actData;
    protected $actContent;

    protected $actOptions;
    protected $actOption;

    protected $isContent;

    public function __construct()
    {

    }

    public function parse($xmlData)
    {

        try {
            $xmlIterator = new \SimpleXMLIterator($xmlData);

            return $this->outputHtml($xmlIterator);

        } catch (\Exception $e) {
            return '';
        }
//        echo $this->output;
        //var_dump($this->output);
        //die();

    }

    private function outputHtml($xmlIterator)
    {

//    echo $xmlIterator->count();

        if (!$xmlIterator->count()) {
            return '';
        }

        $output = '';

//    echo 'LEVEL: ' . $this->level;
//    echo '<br>';
        $this->level++;
        for ($xmlIterator->rewind(); $xmlIterator->valid(); $xmlIterator->next()) {
//      echo $xmlIterator->key();
//      echo '<br>';
//      echo $xmlIterator->hasChildren();
//      echo '<br>';
//      echo '<br>';
            if ($xmlIterator->hasChildren()) {
                $functionName = 'wrap' . ucfirst(str_replace('-', '', $xmlIterator->key()));
                $this->addWrapper($xmlIterator->key());
                $output .= $this->$functionName($this->outputHtml($xmlIterator->current()));
                $this->removeWrapper($xmlIterator->key());
            } else {
                $functionName = 'output' . ucfirst(str_replace('-', '', $xmlIterator->key()));
//        echo $functionName . '<br>';
                $output .= $this->$functionName($xmlIterator->current());
            }

            //var_dump($xmlIterator);
            //$output .= $this->outputHtml($xmlIterator);

        }
        $this->level--;
//    echo '<br>';
//    echo '<br>';
//

        return $output;
//    foreach ($this->data as $baseNodeName => $baseNode) {
//      echo $baseNodeName;
//      var_dump($baseNode);
//      echo '<br>';
//    }
        // die();

    }

    private function addWrapper($wrapper)
    {
        $this->wrappers[$wrapper] = true;
    }

    private function removeWrapper($wrapper)
    {
        $this->wrappers[$wrapper] = false;
    }

    private function existsWrapper($wrapper)
    {
        return $this->wrappers[$wrapper];
    }

    private function outputHeadline($node)
    {
        return '<h2 class="standard">' . $node . '</h2>';
    }

    private function outputParagraph($node)
    {
        return '<p>' . $node . '</p>';
    }

    private function outputItem($node)
    {
        return '<li>' . $node . '</li>';
    }

    private function outputHeader($node)
    {
        return '<div class="toggler">' . $node . '</div>';
    }

    private function outputTableheadline($node)
    {
        return '<h2>' . $node . '</h2>';
    }

    private function outputTh($node)
    {
        return '<th>' . $node . '</th>';
    }

    private function outputTd($node)
    {
        return '<td>' . $node . '</td>';
    }

    private function wrapContent($content)
    {
        $output = '';
        $output .= '<div class="accordion"><div>';
        $output .= $content;
        $output .= '</div></div>';

        return $output;
    }

    private function wrapAccordion($content)
    {
        $output = '';
        $output .= $content;

        return $output;
    }

    private function wrapAccordionitem($content)
    {
        $output = '';
        $output .= '<section class="ce_accordionStart ce_accordion block">';
        $output .= $content;
        $output .= '</section>';

        return $output;
    }

    private function wrapTable($content)
    {
        $output = '';
        $output .= '<div class="ce_table standard block">';
        $output .= $content;
        $output .= '</div>';

        return $output;
    }

    private function wrapTablecontent($content)
    {
        $output = '';
        $output .= '<table>';
        $output .= $content;
        $output .= '</table>';

        return $output;
    }

    private function wrapTableheader($content)
    {
        $output = '';
        $output .= '<thead>';
        $output .= $content;
        $output .= '</thead>';

        return $output;
    }

    private function wrapTablebody($content)
    {
        $output = '';
        $output .= '<tbody>';
        $output .= $content;
        $output .= '</tbody>';

        return $output;
    }

    private function wrapTablerow($content)
    {
        $output = '';
        $output .= '<tr>';
        $output .= $content;
        $output .= '</tr>';

        return $output;
    }

    private function wrapInfobox($content)
    {
        $output = '';
        $output .= '<div class="ce_text hint-grey wo-teaserlink block">';
        $output .= '<div class="text_container">';
        $output .= $content;
        $output .= '</div>';
        $output .= '</div>';

        return $output;
    }

    private function wrapListunnumbered($content)
    {
        $output = '';
        $output .= '<div class="ce_list standard block">';
        $output .= '<ul>';
        $output .= $content;
        $output .= '</ul>';
        $output .= '</div>';

        return $output;
    }

    private function wrapText($content)
    {
        $output = '';
        if (!$this->existsWrapper('infobox')) {
            $output .= '<div class="ce_text standard wo-teaserlink block">';
            $output .= '<div class="text_container">';
        }
        $output .= $content;
        if (!$this->existsWrapper('infobox')) {
            $output .= '</div>';
            $output .= '</div>';
        }

        return $output;
    }

    public function _parse($xmlData)
    {

        $this->output = array();

        if (!strlen($xmlData)) {
            return array();
        }

        $xml_parser = xml_parser_create();
        // use case-folding so we are sure to find the tag in $map_array
        //xml_parser_set_option($xml_parser, XML_OPTION_CASE_FOLDING, true);
        xml_set_element_handler($xml_parser, array($this, "startElement"), array($this, "endElement"));
        xml_set_character_data_handler($xml_parser, array($this, "characterData"));

        if (!xml_parse($xml_parser, $xmlData)) {
            die(
            sprintf(
                "XML error: %s at line %d",
                xml_error_string(xml_get_error_code($xml_parser)),
                xml_get_current_line_number($xml_parser)
            )
            );
        }

        xml_parser_free($xml_parser);

//    echo '<pre>';
//    var_dump($this->output);
//    echo '</pre>';
//    die();

        return $this->output;

    }


    private function startElement($parser, $name, $attrs)
    {

        if ($name == 'HEADLINE') {
            $this->actOutput = array();

        } elseif ($name == 'TEXT') {
            $this->actOutput = array();
            $this->actParts = array();

        } elseif ($name == 'LIST-UNNUMBERED') {
            $this->actOutput = array();
            $this->actParts = array();

        } else {
            $this->actContent = '';

        }

//      $this->actRow = array();
//      $this->actRow['layout'] = 'row';
//
//
//
//      //echo 'start'.$name.'<br />';
//    if ($name == 'ROW') {
//      $this->actRow = array();
//      $this->actRow['layout'] = 'row';
//
//    } elseif ($name == 'LEFT') {
//      $this->actLeft = array();
//      //$this->actLeft['col'] = 'left';
//
//    } elseif ($name == 'RIGHT') {
//      $this->actRight = array();
//      //$this->actRight['col'] = 'right';
//
//    } elseif ($name == 'ADDFIELD') {
//      $this->actAddField = array();
//
//    } elseif ($name == 'OPTIONS') {
//      $this->actOptions = array();
//
//      //} elseif ($name == 'OPTION') {
//      //  $this->actOption = array();
//
//    } else {
//      $this->actContent = '';
//      $this->actNode = $name;
//
//    }

        $this->isContent = false;
    }


    private function endElement($parser, $name)
    {

        if ($name == 'HEADLINE') {
            $this->actOutput['type'] = 'headline';
            $this->actOutput['content'] = $this->actContent;
            array_push($this->output, $this->actOutput);

        } elseif ($name == 'TEXT') {
            $this->actOutput['type'] = 'text';
            $this->actOutput['paragraphs'] = $this->actParts;
            array_push($this->output, $this->actOutput);

        } elseif ($name == 'LIST-UNNUMBERED') {
            $this->actOutput['type'] = 'ul';
            $this->actOutput['items'] = $this->actParts;
            array_push($this->output, $this->actOutput);

        } elseif ($name == 'PARAGRAPH') {
            array_push($this->actParts, $this->actContent);

        } elseif ($name == 'ITEM') {
            array_push($this->actParts, $this->actContent);


//    if ($name == 'ROW') {
//      array_push($this->output, $this->actRow);
//      $this->actRow = null;
//
//    } elseif ($name == 'LEFT') {
//      $this->actRow['left'] = $this->actLeft;
//      $this->actLeft = null;
//
//    } elseif ($name == 'RIGHT') {
//      $this->actRow['right'] = $this->actRight;
//      $this->actRight = null;
//
//    } elseif ($name == 'ADDFIELD') {
//      if (is_array($this->actRow)) {
//        if (is_array($this->actLeft)) {
//          array_push($this->actLeft, $this->actAddField);
//        } else {
//          array_push($this->actRight, $this->actAddField);
//        }
//      } else {
//        $this->actAddField['layout'] = 'single';
//        array_push($this->output, $this->actAddField);
//      }
//
//    } elseif ($name == 'OPTIONS') {
//      $this->actAddField['options'] = $this->actOptions;
//
//      //} elseif ($name == 'OPTION') {
//      //  $this->actAddField['options']['option'] = $this->actOption);
//
//
//    } elseif (($name != 'ADDFIELD') && ($name != 'OPTIONS')) {
//      if ($name == 'OPTION') {
//        $this->actOptions[] = $this->actContent;
//      } else {
//        $this->actAddField[strtolower($name)] = $this->actContent;
//      }

        } else {
            //echo "###START###".$name.' '.$this->actContent . "<br /><br />";
            $this->actContent = preg_replace('/\s+/', ' ', $this->actContent);
            $this->actContent = ((trim($this->actContent) == 'NULL') || (trim(
                        $this->actContent
                    ) == '')) ? '' : $this->actContent;
            //array_push($this->actCategory[$this->actNode], $this->actContent);
        }

        $this->isContent = false;
    }


    private function characterData($parser, $data)
    {
        if (strlen(trim($data)) != 0) {
            if (!$this->isContent) {
                $this->actContent = $data;
            } else {
                $this->actContent .= $data;
            }
        }
        $this->isContent = true;
        //array_push($this->actCategory[$this->actNode], $data);
    }


    public function _outputHtml()
    {

        $html = '';

        foreach ($this->output as $element) {
            $actHtml = '';

            if ($element['type'] == 'headline') {
                $actHtml .= $this->wrapTag('h2', $element['content'], standard);

            } elseif ($element['type'] == 'text') {
                foreach ($element['paragraphs'] as $paragraph) {
                    $actHtml .= $this->wrapTag('p', $paragraph);
                }
                $actHtml = $this->wrapTextContainer($actHtml);

            } elseif ($element['type'] == 'ul') {
                foreach ($element['items'] as $item) {
                    $actHtml .= $this->wrapTag('li', $item);
                }
                $actHtml = $this->wrapListContainer($actHtml);

            }

            $html .= $actHtml;
        }

        return $html;

    }

    private function wrapTextContainer($content, $type = false)
    {
        $output = '';
        $output .= '<div class="ce_text standard wo-teaserlink block">';
        $output .= '<div class="text_container">';
        $output .= $content;
        $output .= '</div>';
        $output .= '</div>';

        return $output;
    }

    private function wrapListContainer($content, $type = false)
    {
        $output = '';
        $output .= '<div class="ce_list standard block">';
        $output .= '<ul>';
        $output .= $content;
        $output .= '</ul>';
        $output .= '</div>';

        return $output;
    }

    private function wrapTag($tagname, $content, $class = '')
    {
        $output = '';
        $output .= '<' . $tagname . ($class ? ' class=' . $class : '') . '>';
        $output .= $content;
        $output .= '</' . $tagname . '>';

        return $output;

    }

}
