<?php

namespace Dmkzwo\ContaoEventapiBundle\Classes;

class EventCollectionFilters
{
    public static function getFilters()
    {
        $senderClient = new SenderApiClient();
        $targetgroupClient = new TargetgroupApiClient();
        $stateClient = new StateApiClient();

        return [
            'format' => [
                'name' => 'fm',
                'type' => 'filter_multiple_checkbox',
                'options' => DcaHelper::getEventFormats(),
                'values' => \Input::get('fm') ?: [],
            ],
            'sender' => [
                'name' => 'se',
                'type' => 'filter_multiple_checkbox',
                'options' => $senderClient->getLutPublished(),
                'values' => \Input::get('se') ?: [],
            ],
            'targetgroup' => [
                'name' => 'tg',
                'type' => 'filter_multiple_checkbox',
                'options' => $targetgroupClient->getLutPublished(),
                'values' => \Input::get('tg') ?: [],
            ],
            'state' => [
                'name' => 'st',
                'type' => 'filter_multiple_checkbox',
                'options' => $stateClient->getLutPublished(),
                'values' => \Input::get('st') ?: [],
            ],
            'zip' => [
                'name' => 'zp',
                'type' => 'filter_zip',
                'values' => [
                    'zip' => \Input::get('zp') ?: '',
                    'radius' => \Input::get('rd') ?: 150
                ],
            ],
            'month' => [
                'name' => 'mo',
                'type' => 'filter_month',
                'options' => DcaHelper::getNextTwelveMonth(),
                'values' => \Input::get('mo') ?: 0,
            ],
        ];
    }
}
