<?php

namespace Dmkzwo\ContaoEventapiBundle\Classes;


class EventApiClient extends BaseApiClient
{
    protected $baseEndpoint = 'events';

    public function setCalendars($calendarIds = []): EventApiClient
    {
//        $this->addParamMultiple('calendar', $calendarIds, '/api/calendars/');
        $this->addParamMultiple('calendar.id', $calendarIds);

        return $this;
    }

    public function setWebsite($website = 'de')
    {
        $this->addParam('websites', $website);

        return $this;
    }

    public function onlyFuture()
    {
        $this->addParam('startDate[after]', 'now');

        return $this;
    }

    public function setSenders($senderIds = []) {
//        $this->addParamMultiple('sender', $senderIds, '/api/senders/');
        $this->addParamMultiple('sender.id', $senderIds);

        return $this;
    }

    public function setTargetGroups($ids = []) {
//        $this->addParamMultiple('targetGroup', $ids, '/api/target_groups/');
        $this->addParamMultiple('targetGroup.id', $ids);

        return $this;
    }

    public function setStates($ids = []) {
//        $this->addParamMultiple('states', $ids, '/api/states/');
        $this->addParamMultiple('states.id', $ids);

        return $this;
    }

    public function setFormats($ids = []) {
//        $this->addParamMultiple('states', $ids, '/api/states/');
        $this->addParamMultiple('format', $ids);

        return $this;
    }

    public function setProximity($values) {
        $this->addParam('proximity', implode(',', $values));

        return $this;
    }

    public function setMonth($values)
    {
        $start = $values . '-01';
        $end = $start . ' + 1 month';

        $this->addParam('startDate[after]', $start);
        $this->addParam('startDate[before]', $end);

        return $this;
    }

    public function getPublishedEventById($id)
    {
        $event = $this->getOne($id);

        if (!$event['published']) {
            return null;
        }

        return $event;
    }

    public function getEventById($id, $params = []) {
        return $this->getOne($id);
    }


    //    public function getFutureEventsByCalendarsAndWebsite($calendarIds = [], $website = 'de', $params = []) {
//        $params['startDate[after]'] = 'now';
//        $params['websites'] = $website;
//
//        $params['order[startDate]'] = 'asc';
//
//        if (sizeof($calendarIds)) {
//            foreach ($calendarIds as $calendarId) {
//                $params['calendar[]'] = '/api/calendars/' . $calendarId;
//            }
//        }
//
//        return $this->get('events', $params, false);
//    }

}
