<?php

namespace Dmkzwo\ContaoEventapiBundle\Classes;


class DcaHelper
{
    public static function getCalendars() {
        $client = new CalendarApiClient();

        $calendarArr = $client->getCollection();
//        dd($calendarArr->getContent());

//        $calendarArr = CalendarApiClient::getCalendars();

        if (!$calendarArr || !is_array($calendarArr)) {
            return [];
        }

        $options = [];

        foreach ($calendarArr as $calendar) {
            $options[$calendar['id']] = $calendar['name'];
        }

        return $options;
    }

    public static function getEventFormats() {
        return [
            '1' => $GLOBALS['TL_LANG']['eventapi']['event_format'][1],
            '2' => $GLOBALS['TL_LANG']['eventapi']['event_format'][2],
            '0' => $GLOBALS['TL_LANG']['eventapi']['event_format'][0],
        ];
    }

    public static function getNextTwelveMonth() {
        $options = [];

        for ($i=0; $i<12; $i++) {
            $monthTime = strtotime('+'.$i.' month');

            $optionValue = date('Y-m', $monthTime);
            $optionLabel = $GLOBALS['TL_LANG']['eventapi']['month'][date('n', $monthTime)] . ' ' . date('Y', $monthTime);

            $options[$optionValue] = $optionLabel;
        }

        return $options;
    }
}
