<?php

namespace Dmkzwo\ContaoEventapiBundle\Classes;

//use Symfony\Contracts\HttpClient\HttpClientInterface;
use Symfony\Component\HttpClient\HttpClient;

class BaseApiClient
{
    protected $params = [];
    protected $debug = false;

    protected $baseEndpoint = '';
    protected $endpoint = '';

    protected $header = [];

    public function __construct()
    {
//        $this->client = new HttpClientInterface();
        $this->client = HttpClient::create();
    }

    public function getCollection() {
        $this->endpoint = $this->baseEndpoint;

        $responseData = $this->get();

        $this->header['total'] = $responseData['hydra:totalItems'];

//            dump($response->getInfo());
//            dd($response->toArray());

        return $responseData['hydra:member'] ?: [];
    }

    public function getFirstFromCollection() {
        $results = $this->getCollection();

        if (sizeof($results)) {
            return $results[0];
        }

        return false;
    }

    public function getOne($id)
    {
        $this->endpoint = $this->baseEndpoint . '/' . $id;

        $responseData = $this->get();

        return $responseData ?: false;
    }

    public function setDebug($debug = true)
    {
        $this->debug = $debug;
    }

    public function setPage($pageNum)
    {
        $this->params['page'] = $pageNum;

        return $this;
    }

    public function setItemsPerPage($perPage)
    {
        $this->params['itemsPerPage'] = $perPage;

        return $this;
    }

    public function addParam($key, $value)
    {
        $this->params[$key] = $value;

        return $this;
    }

    public function addParams($params = [])
    {
        $this->params = array_replace($this->params, $params);

        return $this;
    }

    public function addParamMultiple($name, $values, $prefix = '')
    {
        $param = [];

        if (is_array($values) && sizeof($values)) {
            foreach ($values as $value) {
                $param[] = $prefix . $value;
            }

            $this->addParam($name, $param);
        }

        return $this;
    }

    public function setOrder($key, $sorting)
    {
        $this->params['order[' . $key . ']'] = $sorting;
    }

    protected function createUrl()
    {
        return sprintf("%s/%s", \System::getContainer()->getParameter('eventapi.url'), $this->endpoint);
    }

    public function createGetUrl()
    {
        $url = sprintf("%s/%s", \System::getContainer()->getParameter('eventapi.url'), $this->endpoint);

        if (is_array($this->params) && sizeof($this->params)) {
            // convert bool to string
//            foreach ($this->params as &$param) {
//                if (is_bool($param)) {
//                    $param = $param ? 'true' : 'false';
//                }
//            }

            $getParams = $this->createQueryString($this->params);
            $url .= '?' . $getParams;
        }

        return $url;
    }

    protected function createQueryString(array $queryArray = []): ?string
    {
        // needed for multiple get parameters with the same name, e.g. sender[]=for&sender[]=bar

        $queryString = http_build_query($queryArray, '', '&', \PHP_QUERY_RFC3986);
        $queryString = preg_replace('/%5B(?:[0-9]|[1-9][0-9]+)%5D=/', '%5B%5D=', $queryString); //foo[]=x&foo[]=y

        return '' !== $queryString ? $queryString : null;
    }

    public function getUrl()
    {
        return $this->createGetUrl();
    }

    public function getTotal()
    {
        return $this->header['total'];
    }

    protected function get()
    {
        $url = $this->createGetUrl();

        try {
            $response = $this->client->request(
                'GET',
                $url,
                [
                    'headers' => [
                        'Accept' => 'application/ld+json',
                        'Content-Type' => 'application/ld+json',
                        'Authorization' => 'Bearer ' . \System::getContainer()->getParameter('eventapi.token')
                    ],
//                    'query' => $this->params,
                    'verify_peer' => false
                ]
            );

            if ($this->debug) {
//                dump('debug output: ');
                dump(urldecode($url));
                dd($response->toArray(false));
            }

            $responseData = $response->toArray();

            return $responseData;

//            $this->header['total'] = $responseData['hydra:totalItems'];



//            dump($response->getInfo());
//            dd($response->toArray());

//            return $responseData['hydra:member'];

        } catch (\Exception $e) {
//            dump('debug output: ');
//            dump(urldecode($url));
//            dd($e);

            return false;
        }

    }

    protected function post()
    {
        $this->endpoint = $this->baseEndpoint;

//        try {
            $response = $this->client->request(
                'POST',
                $this->createUrl(),
                [
                    'headers' => [
                        'Accept' => 'application/ld+json',
                        'Content-Type' => 'application/ld+json',
                        'Authorization' => 'Bearer ' . \System::getContainer()->getParameter('eventapi.token'),
                    ],
                    'json' => $this->params,
                    'verify_peer' => false
                ]
            );

            if ($this->debug) {
                dump('debug output: ');
                dd($response->toArray(false));
            }

            return $response;

//        } catch (\Exception $e) {
//            dd($e);
//
//            return false;
//        }
    }

    protected function patch($id)
    {
        $this->endpoint = $this->baseEndpoint . '/' . $id;

        $response = $this->client->request(
            'PATCH',
            $this->createUrl(),
            [
                'headers' => [
                    'Accept' => 'application/json',
                    'Content-Type' => 'application/merge-patch+json',
                    'Authorization' => 'Bearer ' . \System::getContainer()->getParameter('eventapi.token'),
                ],
                'json' => $this->params,
                'verify_peer' => false
            ]
        );

        if ($this->debug) {
            dump('debug output: ');
            dd($response->toArray());
        }

        return $response;
    }

    public function getLutAll() {
        $items = $this->getCollection();

        $lut = [];

        foreach ($items as $item) {
            $lut[$item['id']] = $item['name'];
        }

        return $lut;
    }

    public function getLutPublished() {
        $this->addParam('published', true);
        $this->setOrder('sorting', 'asc');

        $items = $this->getCollection();

        $lut = [];

        foreach ($items as $item) {
            $lut[$item['id']] = $item['name'];
        }

        return $lut;
    }

    protected static function runGetRequests(string $endpoint, array $params, bool $debug)
    {
        $apiRequest = new ApiRequest($endpoint, $params, $debug);
        $apiRequest->runGet();

        $errorCode = $apiRequest->getErrorCode();
        $status = $apiRequest->getStatus();

        if ($errorCode || ($status['http_code'] == '404')) {
            return [];
        }

        return $apiRequest->getData();
    }

    protected static function runPostRequest(string $endpoint, array $params, bool $debug)
    {
        $apiRequest = new ApiRequest($endpoint, $params, $debug);
        $apiRequest->runPost();

        $errorCode = $apiRequest->getErrorCode();
        $status = $apiRequest->getStatus();

        if ($errorCode || ($status['http_code'] == '404')) {
            return [];
        }

        return $apiRequest->getData();
    }
}
