<?php

namespace Dmkzwo\ContaoEventapiBundle\Classes;


class ApiRequest
{
    protected $url;
    protected $params;
    protected $header = ['Accept: application/json'];

    protected $response;
    protected $errCode;
    protected $status = [];

    protected $debug;

    public function __construct($url, $params = [], $debug = false)
    {
        $this->url = \System::getContainer()->getParameter('eventapi.url') . '/' . $url;
        $this->params = $params;
        $this->debug = $debug;
    }

    public function addHeader($header) {
        $this->header[] = $header;
    }

    public function runGet() {
        return $this->run('GET');
    }

    public function runPost() {
        $this->addHeader('Content-Type: application/ld+json');
        return $this->run('POST');
    }

    public function runPatch() {
        $this->addHeader('Content-Type: application/merge-patch+json');
        return $this->run('PATCH');
    }

    public function runPut() {
        return $this->run('PUT');
    }


    protected function run($type = 'GET')
    {
        $curl_session = curl_init();

        $requestUrl = $this->url;


        if (($type === 'GET') && sizeof($this->params)) {
            $fields = http_build_query($this->params);
            $requestUrl .= '?' . $fields;
        } else {
            $fields = json_encode($this->params);
        }

        curl_setopt($curl_session, CURLOPT_URL, $requestUrl);
//        curl_setopt($curl_session, CURLOPT_PORT, 4443);
        curl_setopt($curl_session, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curl_session, CURLOPT_RETURNTRANSFER, true);

//        curl_setopt($curl_session, CURLOPT_SSL_VERIFYHOST, false);
//        curl_setopt($curl_session,CURLOPT_FOLLOWLOCATION, true);
//        curl_setopt($curl_session, CURLOPT_SSL_VERIFYHOST, 2);

        curl_setopt($curl_session, CURLOPT_CUSTOMREQUEST, $type);

        if (in_array($type, ['POST', 'PUT', 'PATCH'])) {
            curl_setopt($curl_session, CURLOPT_POSTFIELDS, $fields);
        }

        curl_setopt($curl_session, CURLOPT_HTTPHEADER, $this->header);

        if ($this->debug) {
            dump($type . ': ' . $requestUrl);
            dump($fields);
            dump($this->header);
        }

        return $this->execCurl($curl_session);

        curl_close($curl_session);

    }

    protected function execCurl($curl_session) {
        $this->response = curl_exec($curl_session);

        $this->errCode = curl_errno($curl_session);

        if (!$this->errCode) {
            $this->status = curl_getinfo($curl_session);
        } else {
            $this->status['http_code'] = '500';
        }

        if ($this->debug) {
            dump('Error code: ' . $this->errCode);
            dump($this->status);
            dd();
        }

        return $this->status['http_code'];
    }

    public function getJsonData() {
//        var_dump($this->response);
//        die();

        return $this->response;
    }

    public function getData() {
//        var_dump($this->response);
//        die();

//        dd(json_decode($this->response));

        return json_decode($this->response);
    }

    public function getErrorCode() {
        return $this->errCode;
    }

    public function getStatus() {
        return $this->status;
    }


//    public function runGetV1()
//    {
//
//        $curl_session = curl_init();
//
//
//        $requestUrl = $this->url;
//
//        if (sizeof($this->params)) {
//            $fields = http_build_query($this->params);
//            $requestUrl .= '?' . $fields;
//        }
//
////        echo $requestUrl;
//
//        curl_setopt($curl_session, CURLOPT_URL, $requestUrl);
//        curl_setopt($curl_session, CURLOPT_RETURNTRANSFER, true);
////        curl_setopt($curl_session, CURLOPT_SSL_VERIFYHOST, 2);
//
////        curl_setopt($curl_session, CURLOPT_CUSTOMREQUEST, "POST");
////        curl_setopt($curl_session, CURLOPT_POSTFIELDS, $fields);
//
////        curl_setopt($curl_session, CURLOPT_HTTPHEADER, array(
////                'Content-Type: application/json',
//////                'Authorization: OAuth SomeOAuthaccess'
////            )
////        );
//
//        curl_setopt($curl_session, CURLOPT_HTTPHEADER, $this->header);
//
////        $this->response = curl_exec($curl_session);
//        $this->execCurl($curl_session);
//
//        curl_close($curl_session);
//    }
//
//    public function runPostV1()
//    {
//        $fields = http_build_query($this->params);
//
//        $curl_session = curl_init();
//
//        $requestUrl = $this->url;
//
//        curl_setopt($curl_session, CURLOPT_URL, $requestUrl);
//        curl_setopt($curl_session, CURLOPT_RETURNTRANSFER, true);
////        curl_setopt($curl_session, CURLOPT_SSL_VERIFYHOST, 2);
//
//        curl_setopt($curl_session, CURLOPT_CUSTOMREQUEST, "POST");
//        curl_setopt($curl_session, CURLOPT_POSTFIELDS, $fields);
//
////        curl_setopt($curl_session, CURLOPT_HTTPHEADER, array(
////                'Content-Type: application/json',
//////                'Authorization: OAuth SomeOAuthaccess'
////            )
////        );
//
//        curl_setopt($curl_session, CURLOPT_HTTPHEADER, $this->header
////        array(
////                'Accept: application/json',
//////                'Authorization: OAuth SomeOAuthaccess'
////            )
//        );
//
////        $this->response = curl_exec($curl_session);
//        $this->execCurl($curl_session);
//
//        curl_close($curl_session);
//    }

}
